/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpInvokeUtil {
    private static Log log = LogFactory.getLog(HttpInvokeUtil.class);
    private static final int RETRY_TIMES = 3;

    protected static HttpResponse executeHttpRequest(HttpUriRequest httpRequest) throws ClientProtocolException, IOException {
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        int retryTimes = 3;
        while (true) {
            try {
                return tClient.execute(httpRequest);
            }
            catch (Exception e) {
                log.warn((Object)e);
                if (--retryTimes <= 0) {
                    throw e;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                    throw e;
                }
            }
        }
    }
}

