/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EocOmTransformUtil {
    private static final String OM_REGULAR = "[\"]om_company_id[\"]\\s*:\\s*[\"].+[\"]";
    private static final String OM_COMPAMY_ID_CM01_REGULAR = "[\"']om_company_id[\"']\\s*:\\s*[\"']Cm01[\"']";
    private static final String OM_SITE_ID_001_REGULAR = "[\"']om_site_id[\"']\\s*:\\s*[\"']Pt01[\"']";
    private static final String OM_SITE_ID_002_REGULAR = "[\"']om_site_id[\"']\\s*:\\s*[\"']Pt02[\"']";
    private static final String OM_SITE_ID_003_REGULAR = "[\"']om_site_id[\"']\\s*:\\s*[\"']Pt03[\"']";
    private static final String EOC_COMPANY_ID_CM01_DATA = "\"om_company_id\":\"Cm01\",\"eoc_company_id\":\"TCm01\"";
    private static final String EOC_SITE_ID_001_DATA = "\"om_site_id\":\"Pt01\",\"eoc_site_id\":\"TPt01\"";
    private static final String EOC_SITE_ID_002_DATA = "\"om_site_id\":\"Pt02\",\"eoc_site_id\":\"Pt02\"";
    private static final String EOC_SITE_ID_003_DATA = "\"om_site_id\":\"Pt03\",\"eoc_site_id\":\"Pt03\"";
    private static final String EOC_REGULAR = "[\"']eoc_(company|site|region)_id[\"']\\s*:\\s*[\"'].+[\"']";
    private static final String EOC_COMPAMY_ID_CM01_REGULAR = "[\"']eoc_company_id[\"']\\s*:\\s*[\"']TCm01[\"']";
    private static final String EOC_SITE_ID_001_REGULAR = "[\"']eoc_site_id[\"']\\s*:\\s*[\"']Pt01[\"']";
    private static final String EOC_SITE_ID_002_REGULAR = "[\"']eoc_site_id[\"']\\s*:\\s*[\"']Pt02[\"']";
    private static final String EOC_SITE_ID_003_REGULAR = "[\"']eoc_site_id[\"']\\s*:\\s*[\"']Pt03[\"']";
    private static final String OM_COMPANY_ID_CM01_DATA = "\"eoc_company_id\":\"TCm01\",\"om_company_id\":\"Cm01\"";
    private static final String OM_SITE_ID_001_DATA = "\"eoc_site_id\":\"TPt01\",\"om_site_id\":\"Pt01\"";
    private static final String OM_SITE_ID_002_DATA = "\"eoc_site_id\":\"Pt02\",\"om_site_id\":\"Pt02\"";
    private static final String OM_SITE_ID_003_DATA = "\"eoc_site_id\":\"Pt03\",\"om_site_id\":\"Pt03\"";

    public static String transform(String body) {
        Pattern tOMRegexP = Pattern.compile(OM_REGULAR);
        Matcher tOMMatch = tOMRegexP.matcher(body);
        if (tOMMatch.find()) {
            return body.replaceAll(OM_COMPAMY_ID_CM01_REGULAR, EOC_COMPANY_ID_CM01_DATA).replaceAll(OM_SITE_ID_001_REGULAR, EOC_SITE_ID_001_DATA).replaceAll(OM_SITE_ID_002_REGULAR, EOC_SITE_ID_002_DATA).replaceAll(OM_SITE_ID_003_REGULAR, EOC_SITE_ID_003_DATA);
        }
        Pattern tEOCRegexP = Pattern.compile(EOC_REGULAR);
        Matcher tEOCMatch = tEOCRegexP.matcher(body);
        if (tEOCMatch.find()) {
            return body.replaceAll(EOC_COMPAMY_ID_CM01_REGULAR, OM_COMPANY_ID_CM01_DATA).replaceAll(EOC_SITE_ID_001_REGULAR, OM_SITE_ID_001_DATA).replaceAll(EOC_SITE_ID_002_REGULAR, OM_SITE_ID_002_DATA).replaceAll(EOC_SITE_ID_003_REGULAR, OM_SITE_ID_003_DATA);
        }
        return body;
    }
}

