/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.mq;

import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.model.MqPublishParam;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;

public class RabbitMqManager {
    private static RabbitMqManager rabbitMQManager = null;
    private Connection connection = null;

    static {
        try {
            rabbitMQManager = new RabbitMqManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static RabbitMqManager getRabbitMQManager() {
        if (rabbitMQManager == null) {
            throw new RuntimeException("RabbitMQ created failed");
        }
        return rabbitMQManager;
    }

    private RabbitMqManager() throws Exception {
        if (URLConstant.MQ_URL == null || URLConstant.MQ_URL.length() == 0) {
            throw new RuntimeException("esp-sdk rabbitmq properties config error");
        }
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUri(URLConstant.MQ_URL);
        this.connection = factory.newConnection();
    }

    public boolean publishMessage(MqPublishParam publishParam) {
        boolean result = false;
        if (publishParam.getMessage() == null || publishParam.getMessage().isEmpty()) {
            throw new RuntimeException("message can't be empty");
        }
        if (publishParam.getQueueName() == null || publishParam.getQueueName().isEmpty()) {
            throw new RuntimeException("queueName can't be empty");
        }
        if (publishParam.getRoutingKey() == null || publishParam.getRoutingKey().isEmpty()) {
            throw new RuntimeException("routingKey can't be empty");
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Channel channel = this.connection.createChannel();){
                channel.exchangeDeclare(publishParam.getExchangeName(), publishParam.getExchangeType(), publishParam.getPersistent().booleanValue());
                channel.queueDeclare(publishParam.getQueueName(), publishParam.getPersistent().booleanValue(), false, false, null);
                channel.queueBind(publishParam.getQueueName(), publishParam.getExchangeName(), publishParam.getRoutingKey());
                channel.confirmSelect();
                channel.addConfirmListener(new ConfirmListener(){

                    public void handleAck(long deliveryTag, boolean multiple) throws IOException {
                    }

                    public void handleNack(long deliveryTag, boolean multiple) throws IOException {
                        System.out.println("Broker\u53d1\u9001\u786e\u8ba4\u5931\u8d25\uff01deliveryTag=" + deliveryTag + ",multiple=" + multiple);
                    }
                });
                channel.basicPublish(publishParam.getExchangeName(), publishParam.getRoutingKey(), MessageProperties.PERSISTENT_TEXT_PLAIN, publishParam.getMessage().getBytes());
                result = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

