/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.model;

import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.EocDispatchInfoModel;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonObject;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RequestModel {
    private List<EocDispatchInfoModel> dispatchList;
    private Set<String> dispatchCompanys;
    private InvokeTypeEnum invokeType;
    private String hostProd;
    private String hostVer;
    private String hostId;
    private String hostAcct;
    private String hostEmpAcct;
    private String language;
    private String tenantId;
    private String serviceProd;
    private String serviceProdUid;
    private String serviceName;
    private Map<String, String> datakeys;
    private Map<String, String> headers;
    private String bodyJsonString;
    private Map<String, String> eocMap;
    private Map<String, String> omMap;
    private Map<String, String> appver;
    private Map<String, String> debugInfo;

    public List<EocDispatchInfoModel> getEocDispatchInfoModelList() {
        return this.dispatchList;
    }

    public void setEocDispatchInfoModelList(List<EocDispatchInfoModel> dispatchList) {
        this.dispatchList = dispatchList;
    }

    public void addEocDispatchInfo(EocDispatchInfoModel eocDispatchInfoModel) {
        if (this.dispatchList == null) {
            this.dispatchList = new ArrayList<EocDispatchInfoModel>();
        }
        this.dispatchList.add(eocDispatchInfoModel);
    }

    public Set<String> getDispatchCompanys() {
        return this.dispatchCompanys;
    }

    public void setDispatchCompanys(Set<String> dispatchCompanys) {
        this.dispatchCompanys = dispatchCompanys;
    }

    public void addDispatchCompany(String company) {
        if (this.dispatchCompanys == null) {
            this.dispatchCompanys = new HashSet<String>();
        }
        this.dispatchCompanys.add(company);
    }

    public InvokeTypeEnum getInvokeType() {
        return this.invokeType;
    }

    public void setInvokeType(InvokeTypeEnum invokeType) {
        this.invokeType = invokeType;
    }

    public String getHostProd() {
        return this.hostProd;
    }

    public void setHostProd(String hostProd) {
        this.hostProd = hostProd;
    }

    public String getHostVer() {
        return this.hostVer;
    }

    public void setHostVer(String hostVer) {
        this.hostVer = hostVer;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostAcct() {
        return this.hostAcct;
    }

    public void setHostAcct(String hostAcct) {
        this.hostAcct = hostAcct;
    }

    public String getHostEmpAcct() {
        return this.hostEmpAcct;
    }

    public void setHostEmpAcct(String hostEmpAcct) {
        this.hostEmpAcct = hostEmpAcct;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getServiceProd() {
        return this.serviceProd;
    }

    public void setServiceProd(String serviceProd) {
        this.serviceProd = serviceProd;
    }

    public String getServiceProdUid() {
        return this.serviceProdUid;
    }

    public void setServiceProdUid(String serviceProdUid) {
        this.serviceProdUid = serviceProdUid;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getBodyJsonString() {
        return this.bodyJsonString;
    }

    public void setBodyJsonString(String bodyJsonString) {
        this.bodyJsonString = bodyJsonString;
    }

    public Map<String, String> getDatakeyMap() {
        return this.datakeys;
    }

    public void setDatakeyMap(Map<String, String> datakeymap) {
        this.datakeys = datakeymap;
    }

    public String getDatakey(String key) {
        if (this.datakeys == null) {
            return null;
        }
        return this.datakeys.get(key);
    }

    public void addDatakey(String key, String value) {
        if (this.datakeys == null) {
            this.datakeys = new HashMap<String, String>();
        }
        this.datakeys.put(key, value);
    }

    public Map<String, String> getHeaderMap() {
        return this.headers;
    }

    public void setHeaderMap(Map<String, String> headermap) {
        this.headers = headermap;
    }

    public String getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(key);
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public Map<String, String> getEocMap() {
        return this.eocMap;
    }

    public void setEocMap(Map<String, String> eocmap) {
        this.eocMap = eocmap;
    }

    public String getEocId(String tag) {
        if (this.eocMap == null) {
            return null;
        }
        return this.eocMap.get(tag);
    }

    public void addEocId(String tag, String value) {
        if (this.eocMap == null) {
            this.eocMap = new HashMap<String, String>();
        }
        this.eocMap.put(tag, value);
    }

    public Map<String, String> getOmMap() {
        return this.omMap;
    }

    public void setOmMap(Map<String, String> ommap) {
        this.omMap = ommap;
    }

    public String getOmId(String tag) {
        if (this.omMap == null) {
            return null;
        }
        return this.omMap.get(tag);
    }

    public void addOmId(String tag, String value) {
        if (this.omMap == null) {
            this.omMap = new HashMap<String, String>();
        }
        this.omMap.put(tag, value);
    }

    public void setAppVer(String appid, String ver) {
        if (this.appver == null) {
            this.appver = new HashMap<String, String>();
        }
        this.appver.put("appid", appid);
        this.appver.put("ver", ver != null ? ver : "");
    }

    public String getDebugInfo(String tag) {
        if (this.debugInfo == null) {
            return null;
        }
        return this.debugInfo.get(tag);
    }

    public void addDebugInfo(String tag, String value) {
        if (this.debugInfo == null) {
            this.debugInfo = new HashMap<String, String>();
        }
        this.debugInfo.put(tag, value);
    }

    public void setNeedCompress(boolean value) {
        if (value) {
            this.headers.put("digi-need-compress", "{\"encoding\":\"gzip\"}");
        } else {
            this.headers.remove("digi-need-compress");
        }
    }

    public void setDigiCompressed(String value) {
        this.headers.put("digi-compressed", value);
    }

    public String getUserToken() {
        return !StringUtil.isEmptyOrSpace(this.getHeader("token")) ? this.getHeader("token") : Objects.toString(this.getHeader("digi-token"), null);
    }

    public Map<String, Object> getHttpHeaders() {
        HashMap<String, Object> tMap = new HashMap<String, Object>();
        tMap.put("digi-type", this.invokeType.toString().toLowerCase());
        JsonObject tHostJsonObject = new JsonObject();
        tHostJsonObject.addProperty("prod", this.hostProd);
        tHostJsonObject.addProperty("ver", this.hostVer);
        tHostJsonObject.addProperty("ip", "");
        if (this.hostId != null) {
            tHostJsonObject.addProperty("id", this.hostId);
        }
        tHostJsonObject.addProperty("timestamp", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(Calendar.getInstance().getTime()));
        if (this.language != null) {
            tHostJsonObject.addProperty("lang", this.language);
            tMap.put("locale", this.language);
        }
        if (this.hostAcct != null) {
            tHostJsonObject.addProperty("eoc_acct", this.hostAcct);
        }
        if (this.hostEmpAcct != null) {
            tHostJsonObject.addProperty("acct", this.hostEmpAcct);
        }
        tMap.put("digi-host", tHostJsonObject);
        JsonObject tServiceJsonObject = new JsonObject();
        tServiceJsonObject.addProperty("prod", this.serviceProd);
        tServiceJsonObject.addProperty("tenant_id", this.tenantId);
        tServiceJsonObject.addProperty("name", this.serviceName);
        if (this.serviceProdUid != null) {
            tServiceJsonObject.addProperty("uid", this.serviceProdUid);
        }
        tMap.put("digi-service", tServiceJsonObject);
        String keyStr = tHostJsonObject.toString() + tServiceJsonObject.toString();
        String md5Key = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(keyStr.getBytes("UTF-8"));
            byte[] digest = md.digest();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                byte b;
                int value = (b & 0x7F) + ((b = digest[i]) < 0 ? 128 : 0);
                buffer.append(value < 16 ? "0" : "");
                buffer.append(Integer.toHexString(value));
            }
            md5Key = buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tMap.put("digi-key", md5Key);
        if (this.datakeys != null && !this.datakeys.isEmpty()) {
            JsonObject tDatakeyJsonObject = new JsonObject();
            for (String tKey : this.datakeys.keySet()) {
                tDatakeyJsonObject.addProperty(tKey, this.datakeys.get(tKey));
            }
            tMap.put("digi-datakey", tDatakeyJsonObject);
        }
        if (this.eocMap != null) {
            JsonObject tEocMapJsonObject = new JsonObject();
            for (String tKey : this.eocMap.keySet()) {
                if (this.eocMap.get(tKey) == null) continue;
                tEocMapJsonObject.addProperty(tKey, this.eocMap.get(tKey));
            }
            tMap.put("digi-eocmap", tEocMapJsonObject);
        }
        if (this.omMap != null) {
            JsonObject tOmMapJsonObject = new JsonObject();
            for (String tKey : this.omMap.keySet()) {
                if (this.omMap.get(tKey) == null) continue;
                tOmMapJsonObject.addProperty(tKey, this.omMap.get(tKey));
            }
            tMap.put("digi-ommap", tOmMapJsonObject);
        }
        if (this.appver != null) {
            JsonObject tAppverJsonObject = new JsonObject();
            for (String tKey : this.appver.keySet()) {
                if (this.appver.get(tKey) == null) continue;
                tAppverJsonObject.addProperty(tKey, this.appver.get(tKey));
            }
            tMap.put("digi-appver", tAppverJsonObject);
        }
        tMap.put("routerKey", this.getTenantId());
        if (this.headers != null) {
            tMap.putAll(this.headers);
        }
        return tMap;
    }
}

