/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.AbstractInvoker;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.util.EocOmTransformUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.LogUtil;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;

class AppInvoker
extends AbstractInvoker {
    AppInvoker() {
    }

    @Override
    protected String getTargetUrl(MessageModel messageModel) {
        return messageModel.getEocMappingJsonObject().get("url").getAsString();
    }

    @Override
    protected Map<String, Object> getRequestHeaders(RequestModel requestModel) throws ClientProtocolException, ParseException, IOException, JsonFormatException {
        JsonObject tJsonObject;
        requestModel.addHeader("digi-reqid", UUID.randomUUID().toString());
        if (requestModel.getInvokeType().equals((Object)InvokeTypeEnum.FASYNC) && !JsonUtil.isNullOrEmptyOrSpace((tJsonObject = EocOmTransformUtil.getMappingJsonObject(requestModel.getTenantId(), requestModel.getHostProd(), requestModel.getHostId(), null, requestModel.getHeader("digi-dap-service-chain-info"), requestModel.getHeader("security-token"))).get("url"))) {
            requestModel.addHeader("digi-callback-url", String.valueOf(tJsonObject.get("url").getAsString()) + "/callback");
        }
        Map<String, Object> headers = requestModel.getHttpHeaders();
        headers.remove("digi-key");
        return headers;
    }

    @Override
    protected Map<String, Object> getResponseHeaders(HttpResponse httpResponse, RequestModel requestModel) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        Header[] headerArray = httpResponse.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header tHeader = headerArray[n2];
            headers.put(tHeader.getName(), tHeader.getValue());
            ++n2;
        }
        headers.put("digi-reqid", requestModel.getHeader("digi-reqid"));
        headers.put("routerKey", requestModel.getTenantId());
        int status = httpResponse.getStatusLine().getStatusCode();
        if (String.valueOf(status).startsWith("2")) {
            if (requestModel.getInvokeType().equals((Object)InvokeTypeEnum.FASYNC)) {
                headers.put("digi-code", "0E9");
                headers.put("digi-message", "RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWFqOW8guatpeivt+axguaOpeaUtueKtuaAgQ==");
            } else {
                headers.put("digi-code", "019");
                headers.put("digi-message", "RUFJIFJlc3BvbnNlOuW5s+WPsOi/lOWbnuWQjOatpee7k+aenA==");
            }
        } else if (status == 404) {
            headers.put("digi-code", "311");
            headers.put("digi-message", "RUFJIFJlc3BvbnNlOuaXoOazleiBlOacuuiHs+i/nOeoi+acjeWKoQ==");
        } else {
            headers.put("digi-code", "322");
            headers.put("digi-message", "RUFJIFJlc3BvbnNlOui/nOeoi+acjeWKoeWPkeeUn+S+i+Wklg==");
        }
        return headers;
    }

    @Override
    protected void saveRequestLog(String tenantId, Map<String, Object> requestHeaders, Map<String, Object> headers, String messageBody) throws ClientProtocolException, IOException {
        LogUtil.saveLogToLMC("invoke", tenantId, requestHeaders, null, headers, messageBody, null);
    }

    @Override
    protected void saveResponseLog(String tenantId, Map<String, Object> requestHeaders, Integer httpStatus, Map<String, Object> headers, String messageBody) throws ClientProtocolException, IOException {
        LogUtil.saveLogToLMC("invokeRtn", tenantId, requestHeaders, httpStatus, headers, messageBody, null);
    }

    @Override
    protected void saveResponseErrorLog(String tenantId, Map<String, Object> requestHeaders, Exception ex) throws ClientProtocolException, IOException {
        LogUtil.saveLogToLMC("invokeRtn", tenantId, requestHeaders, null, null, null, ex);
    }
}

