/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressUtil {
    private static Log log = LogFactory.getLog(CompressUtil.class);
    private static JsonParser jsonParser = new JsonParser();

    public static String uncompress(String compressedStr) {
        ByteArrayOutputStream tBo = new ByteArrayOutputStream();
        ByteArrayInputStream tBi = new ByteArrayInputStream(Base64.decodeBase64((String)compressedStr));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(tBi);){
                int n;
                byte[] buffer = new byte[1024];
                while ((n = gzipInputStream.read(buffer)) >= 0) {
                    tBo.write(buffer, 0, n);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return new String(tBo.toByteArray());
    }

    public static String compress(String str) {
        ByteArrayOutputStream tZipBo = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(tZipBo);){
                gzipOutputStream.write(str.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return Base64.encodeBase64String((byte[])tZipBo.toByteArray());
    }

    public static String uncompressBody(String compressedBody) {
        try {
            JsonObject tMessageJsonObject = jsonParser.parse(compressedBody).getAsJsonObject();
            String msg = CompressUtil.uncompress(tMessageJsonObject.get("std_data").getAsJsonObject().get("parameter").getAsJsonObject().get("compressed_data").getAsString());
            tMessageJsonObject.get("std_data").getAsJsonObject().add("parameter", jsonParser.parse(msg));
            return tMessageJsonObject.toString();
        }
        catch (Exception e) {
            log.error((Object)e);
            return compressedBody;
        }
    }

    public static String compressBody(String body) {
        try {
            JsonObject tMessageJsonObject = jsonParser.parse(body).getAsJsonObject();
            String compressedMmsg = CompressUtil.compress(tMessageJsonObject.get("std_data").getAsJsonObject().get("parameter").toString());
            JsonObject tJo = new JsonObject();
            tJo.addProperty("compressed_data", compressedMmsg);
            tMessageJsonObject.get("std_data").getAsJsonObject().add("parameter", (JsonElement)tJo);
            return tMessageJsonObject.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return body;
        }
    }
}

