/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.TenantInfoEnum;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.digiwin.athena.esp.sdk.util.EocOmTransformUtil;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class TenantInfoUtil {
    private static final String PATH_MDC_TENANTID_GET = "/OmTenantId/Get";
    private static final String PATH_DAP_MDC_TENANTID_GET = "/restful/standard/mdc/OmTenantId/Get";
    private static final String PATH_TM_SECRETKEY_GET = "/restful/service/knowledgegraph/app/licenseKey?tenantId=";
    private static final String PATH_IAM_USERTOKEN_GET = "/api/iam/v2/identity/login";
    private static final String KEY_HEADER_CHAIN_INFO = "digi-dap-service-chain-info";
    private static final String KEY_HEADER_SECURITY_TOKEN = "security-token";
    private static final String KEY_HEADER_ROUTER_KEY = "routerKey";
    private static final String KEY_HEADER_APP_TOKEN = "digi-middleware-auth-app";
    private static final String KEY_HEADER_APP_SECRET = "digi-middleware-auth-app-secret";
    private static final String KEY_HEADER_USER_TOKEN = "digi-middleware-auth-user";
    private static final String KEY_HEADER_TOKEN = "token";
    private static final String KEY_HEADER_DIGI_TOKEN = "digi-token";

    public static Map<String, String> getTenantIdAndToken(String eaiUid, String prodUid, String omMap) throws Exception {
        return TenantInfoUtil.getTenantIdAndToken(eaiUid, prodUid, omMap, null);
    }

    public static Map<String, String> getTenantIdAndToken(String eaiUid, String prodUid, String omMap, String apptoken) throws Exception {
        String tTenantId = TenantInfoUtil.getTenantId(eaiUid, prodUid, omMap);
        String tSecretKey = TenantInfoUtil.getSecretKey(tTenantId);
        String tUserToken = TenantInfoUtil.getUserToken(tSecretKey, apptoken);
        HashMap<String, String> tMap = new HashMap<String, String>();
        tMap.put(TenantInfoEnum.TENANT_ID.toString(), tTenantId);
        tMap.put(TenantInfoEnum.USER_TOKEN.toString(), tUserToken);
        return tMap;
    }

    public static String getEocMap(String tenantId, String product, String omMap) throws Exception {
        String result = "{}";
        JsonParser tJsonParser = new JsonParser();
        JsonObject tJsonObject = (JsonObject)tJsonParser.parse(omMap);
        HashMap<String, String> tOmMap = new HashMap<String, String>();
        HashMap<String, String> tEocMap = new HashMap<String, String>();
        for (String key : tJsonObject.keySet()) {
            tOmMap.put(key, tJsonObject.get(key).getAsString());
        }
        EocOmTransformUtil.transformEocOmMap(tEocMap, tOmMap, tenantId, product);
        if (!tEocMap.isEmpty()) {
            JsonObject tEocMapJsonObject = new JsonObject();
            for (String tKey : tEocMap.keySet()) {
                tEocMapJsonObject.addProperty(tKey, (String)tEocMap.get(tKey));
            }
            result = tEocMapJsonObject.toString();
        }
        return result;
    }

    private static String getTenantId(String eaiUid, String prodUid, String omMap) throws ClientProtocolException, IOException, TenantInfoNotFoundException, ParseException, JsonFormatException {
        HttpResponse tHttpResponse;
        JsonObject tReturnJsonObject;
        JsonParser tJsonParser = new JsonParser();
        JsonObject tOmMapJsonObject = (JsonObject)tJsonParser.parse(omMap);
        String tURL = String.valueOf(URLConstant.MDC_BASE_URL) + (URLConstant.MDC_BASE_URL.contains("esp") ? PATH_MDC_TENANTID_GET : PATH_DAP_MDC_TENANTID_GET);
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("eai_uid", eaiUid.trim());
        tJsonObject.addProperty("prod_uid", prodUid.trim());
        tJsonObject.add("om_map", (JsonElement)tOmMapJsonObject);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        if (!StringUtil.isEmptyOrSpace((tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost), tURL)).get("tenant_id").getAsString())) {
            return tReturnJsonObject.get("tenant_id").getAsString();
        }
        throw new TenantInfoNotFoundException(String.format("Tenant ID not found.MDC host:[%s], product UID:[%s], ommap:[%s]", URLConstant.MDC_BASE_URL, prodUid.trim(), omMap));
    }

    private static String getSecretKey(String tenantId) throws Exception {
        String tURL = String.valueOf(URLConstant.TM_BASE_URL) + PATH_TM_SECRETKEY_GET;
        HttpGet tHttpGet = new HttpGet(String.valueOf(tURL) + tenantId.trim());
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpGet.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpGet.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpGet);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        String tStatus = null;
        if (tReturnJsonObject.get("status") != null) {
            tStatus = tReturnJsonObject.get("status").getAsString();
        }
        if ("200".equals(tStatus)) {
            String tKey = tReturnJsonObject.get("response").getAsString();
            if (!StringUtil.isEmptyOrSpace(tKey)) {
                return TenantInfoUtil.decodeAES(tReturnJsonObject.get("response").getAsString());
            }
            throw new TenantInfoNotFoundException(String.format("License key is empty or space. ThemeMap host:[%s], tenantId:[%s]", URLConstant.TM_BASE_URL, tenantId));
        }
        String tErrorMessage = null;
        if (tReturnJsonObject.get("errorMessage") != null) {
            tErrorMessage = tReturnJsonObject.get("errorMessage").getAsString();
        }
        throw new TenantInfoNotFoundException(String.format("License key not found. ThemeMap host:[%s], tenantId:[%s], response status:[%s], error message:[%s]", URLConstant.TM_BASE_URL, tenantId, tStatus, tErrorMessage));
    }

    public static String getTenantIdBySecretKey(String secretKey) throws Exception {
        return TenantInfoUtil.getTenantIdBySecretKey(secretKey, null);
    }

    public static String getTenantIdBySecretKey(String secretKey, String appToken) throws Exception {
        return TenantInfoUtil.getIAMUserInfoBySecretKey(secretKey, appToken, IAMEnum.TENANT_ID);
    }

    private static String getUserToken(String secretKey, String apptoken) throws TenantInfoNotFoundException, ClientProtocolException, IOException, ParseException, JsonFormatException {
        return TenantInfoUtil.getIAMUserInfoBySecretKey(secretKey, apptoken, IAMEnum.USER_TOKEN);
    }

    private static String getIAMUserInfoBySecretKey(String secretKey, String apptoken, IAMEnum iamEnum) throws TenantInfoNotFoundException, ClientProtocolException, IOException, ParseException, JsonFormatException {
        String tURL = String.valueOf(URLConstant.IAM_BASE_URL) + PATH_IAM_USERTOKEN_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        if (apptoken != null) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, apptoken);
        } else if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("secretKey", secretKey.trim());
        tJsonObject.addProperty("identityType", "secretKey");
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        if (tReturnJsonObject.get("success") == null || tReturnJsonObject.get("success").getAsString().equals("true")) {
            switch (iamEnum) {
                case TENANT_ID: {
                    return tReturnJsonObject.get("tenantId").getAsString();
                }
                case USER_TOKEN: {
                    return tReturnJsonObject.get(KEY_HEADER_TOKEN).getAsString();
                }
            }
            return "";
        }
        String tCode = null;
        String tMessge = null;
        if (tReturnJsonObject.get("code") != null) {
            tCode = tReturnJsonObject.get("code").getAsString();
        }
        if (tReturnJsonObject.get("message") != null) {
            tMessge = tReturnJsonObject.get("message").getAsString();
        }
        switch (iamEnum) {
            case TENANT_ID: {
                throw new TenantInfoNotFoundException(String.format("Tenant ID not found. IAM host:[%s], response code:[%s], Message:[%s]", URLConstant.IAM_BASE_URL, tCode, tMessge));
            }
            case USER_TOKEN: {
                throw new TenantInfoNotFoundException(String.format("User token not found. IAM host:[%s], response code:[%s], Message:[%s]", URLConstant.IAM_BASE_URL, tCode, tMessge));
            }
        }
        return "";
    }

    private static String decodeAES(String secretFile) throws Exception {
        byte[] result = new byte[]{};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((String)secretKey), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        result = cipher.doFinal(Hex.decodeHex((String)secretFile));
        return new String(result);
    }

    private static enum IAMEnum {
        TENANT_ID,
        USER_TOKEN;

    }
}

