/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

public class JsonUtil {
    private static Gson GSON_INSTANCE = new GsonBuilder().serializeNulls().create();

    public static String toString(Object src) {
        return GSON_INSTANCE.toJson(src);
    }

    public static Map<String, Object> fromJsonMap(String src) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)GSON_INSTANCE.fromJson(src, type);
    }

    protected static JsonObject parseHttpResponseBody(HttpResponse httpResponse, String url) throws ParseException, IOException, JsonFormatException {
        String tBody = null;
        try {
            JsonParser tJsonParser = new JsonParser();
            tBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            return (JsonObject)tJsonParser.parse(tBody);
        }
        catch (JsonSyntaxException e) {
            if (url != null) {
                throw new JsonFormatException(String.format("%s. URL:[%s], response message:[%s]", e.getMessage(), url, tBody));
            }
            throw new JsonFormatException(String.format("%s. message:[%s]", e.getMessage(), tBody));
        }
    }

    public static boolean isNull(JsonElement pElement) {
        return pElement == null || pElement.isJsonNull();
    }

    public static boolean isNullOrEmpty(JsonElement pElement) {
        return pElement == null || pElement.isJsonNull() || "".equals(pElement.getAsString());
    }

    public static boolean isNullOrEmptyOrSpace(JsonElement pElement) {
        return pElement == null || pElement.isJsonNull() || "".equals(pElement.getAsString().trim());
    }
}

