/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

abstract class AbstractInvoker {
    AbstractInvoker() {
    }

    protected abstract String getTargetUrl(MessageModel var1);

    protected abstract Map<String, Object> getRequestHeaders(RequestModel var1) throws ClientProtocolException, ParseException, IOException, JsonFormatException;

    protected abstract Map<String, Object> getResponseHeaders(HttpResponse var1, RequestModel var2);

    protected abstract void saveRequestLog(String var1, Map<String, Object> var2, Map<String, Object> var3, String var4) throws ClientProtocolException, IOException;

    protected abstract void saveResponseLog(String var1, Map<String, Object> var2, Integer var3, Map<String, Object> var4, String var5) throws ClientProtocolException, IOException;

    protected abstract void saveResponseErrorLog(String var1, Map<String, Object> var2, Exception var3) throws ClientProtocolException, IOException;

    protected void execute(MessageModel messageModel) throws ClientProtocolException, IOException, ParseException, JsonFormatException {
        String tTargetUrl = this.getTargetUrl(messageModel);
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        Set<String> tKeySet = reqHeaders.keySet();
        for (String tKey : tKeySet) {
            if (reqHeaders.get(tKey) == null) continue;
            tHttpPost.setHeader(tKey, reqHeaders.get(tKey).toString());
        }
        StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        this.saveRequestLog(messageModel.getRequestModel().getTenantId(), reqHeaders, reqHeaders, messageModel.getRequestModel().getBodyJsonString());
        try {
            CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
            Integer tHttpStatus = tHttpResponse.getStatusLine().getStatusCode();
            Map<String, Object> resHeaders = this.getResponseHeaders((HttpResponse)tHttpResponse, messageModel.getRequestModel());
            ResponseModel tResponseModel = new ResponseModel(resHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
            this.saveResponseLog(messageModel.getRequestModel().getTenantId(), reqHeaders, tHttpStatus, resHeaders, tResponseModel.getBodyJsonString());
            messageModel.setResponseModel(tResponseModel);
        }
        catch (Exception e) {
            this.saveResponseErrorLog(messageModel.getRequestModel().getTenantId(), reqHeaders, e);
            e.printStackTrace();
            throw e;
        }
    }
}

