/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.util.LogUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpInvokeUtil {
    private static Log log = LogFactory.getLog(HttpInvokeUtil.class);
    private static final int RETRY_TIMES = 3;
    private static final long RETRY_INTERVAL = 3000L;

    public static HttpResponse executeHttpRequest(HttpUriRequest httpRequest) throws ClientProtocolException, IOException {
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        int retryTimes = 3;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502) {
                    if (--retryTimes <= 0) {
                        log.warn((Object)("http status " + tStatusCode + ", and retry limit has been exceeded."));
                        LogUtil.saveHttpErrorLogToLMC(httpRequest.getMethod(), httpRequest.getURI().toString(), tResponse.getStatusLine().getStatusCode());
                        return tResponse;
                    }
                    log.warn((Object)("http status " + tStatusCode + ", waiting for retry..."));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)e1);
                        return tResponse;
                    }
                }
                return tResponse;
            }
            catch (Exception e) {
                log.warn((Object)e);
                if (--retryTimes <= 0) {
                    throw e;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                    throw e;
                }
            }
        }
    }
}

