/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.LogUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpInvokeUtil {
    private static Log log = LogFactory.getLog(HttpInvokeUtil.class);
    private static final int RETRY_TIMES = 3;
    private static final long RETRY_INTERVAL = 3000L;

    public static HttpResponse executeHttpRequest(HttpUriRequest httpRequest) throws ClientProtocolException, IOException, JsonFormatException {
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        int retryTimes = 3;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502) {
                    if (--retryTimes <= 0) {
                        log.warn((Object)("http status " + tStatusCode + ", and retry limit has been exceeded."));
                        LogUtil.saveHttpErrorLogToLMC(httpRequest.getMethod(), httpRequest.getURI().toString(), tResponse.getStatusLine().getStatusCode());
                        return tResponse;
                    }
                    log.warn((Object)("http status " + tStatusCode + ", waiting for retry..."));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)e1);
                        return tResponse;
                    }
                }
                return HttpInvokeUtil.checkErrorCode((HttpResponse)tResponse);
            }
            catch (InvocationException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn((Object)e);
                if (--retryTimes <= 0) {
                    throw e;
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                    throw e;
                }
            }
        }
    }

    private static HttpResponse checkErrorCode(HttpResponse response) throws InvocationException, IOException, JsonFormatException {
        HttpEntity entity = response.getEntity();
        entity = new BufferedHttpEntity(entity);
        response.setEntity(entity);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(response, null);
        JsonElement errorCodeE = tReturnJsonObject.get("errorCode");
        if (null != errorCodeE) {
            String errorCode = errorCodeE.getAsString();
            String errorMessage = tReturnJsonObject.get("errorMessage").getAsString();
            JsonObject instructors = tReturnJsonObject.getAsJsonObject("errorInstructors");
            String chainInfo = "";
            if (null != instructors) {
                chainInfo = instructors.get("chainInfo").getAsString();
            }
            throw new InvocationException(errorCode, errorMessage, chainInfo);
        }
        return response;
    }
}

