/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.EspInvoker;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

class EspdpInvoker
extends EspInvoker {
    EspdpInvoker() {
    }

    @Override
    protected String getTargetUrl(MessageModel messageModel) {
        return URLConstant.ESPDP_BASE_URL + "/restful/standard/espdp/dispatch";
    }

    @Override
    protected void execute(MessageModel messageModel) throws ClientProtocolException, IOException, ParseException, JsonFormatException {
        RequestModel requestModel = messageModel.getRequestModel();
        JsonParser jsonParser = new JsonParser();
        String tTargetUrl = this.getTargetUrl(messageModel);
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        JsonObject tHeaderJsonObject = new JsonObject();
        Set<String> tKeySet = reqHeaders.keySet();
        for (String tKey : tKeySet) {
            if (reqHeaders.get(tKey) == null) continue;
            try {
                tHeaderJsonObject.add(tKey, jsonParser.parse(reqHeaders.get(tKey).toString()));
            }
            catch (Exception e) {
                tHeaderJsonObject.addProperty(tKey, reqHeaders.get(tKey).toString());
            }
        }
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.add("dispatch", JsonUtil.toJsonTreeIgnoreNull(requestModel.getEocDispatchInfoModelList()));
        tJsonObject.add("headers", (JsonElement)tHeaderJsonObject);
        if (StringUtil.isEmptyOrSpace(requestModel.getBodyJsonString())) {
            tJsonObject.add("body", (JsonElement)new JsonObject());
        } else {
            tJsonObject.add("body", jsonParser.parse(requestModel.getBodyJsonString()));
        }
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader("token", requestModel.getUserToken());
        tHttpPost.addHeader("routerKey", requestModel.getTenantId());
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost);
            Map<String, Object> resHeaders = this.getResponseHeaders(tHttpResponse, messageModel.getRequestModel());
            ResponseModel tResponseModel = new ResponseModel(resHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
            messageModel.setResponseModel(tResponseModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

