/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.dap.log.service;

import com.digiwin.athena.esp.sdk.DapInvoker;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapLogDto;
import com.digiwin.athena.esp.sdk.util.DapLogHttpClientFactory;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class DapLogService {
    private static Log log = LogFactory.getLog(DapInvoker.class);
    private static final String PATH = URLConstant.ESP_REST_BASE_URL + "/saveDapLogs";
    private static ExecutorService executorService = new ThreadPoolExecutor(10, 30, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), new ThreadPoolExecutor.DiscardPolicy());
    private static CloseableHttpClient httpClient;

    public DapLogService() {
        httpClient = DapLogHttpClientFactory.createHttpClient();
    }

    public void savleLog(DapLogDto dapLogDto) {
        executorService.submit(() -> {
            DapLogDto[] logArray = new DapLogDto[]{dapLogDto};
            HttpPost httpPost = new HttpPost(PATH);
            StringEntity stringEntity = new StringEntity(JsonUtil.toString(logArray), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
            try {
                httpClient.execute((HttpUriRequest)httpPost);
            }
            catch (Exception e) {
                log.error((Object)"send log error {}", (Throwable)e);
            }
        });
    }
}

