/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.LogUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpInvokeUtil {
    private static Log log = LogFactory.getLog(HttpInvokeUtil.class);

    public static HttpResponse executeHttp(HttpUriRequest httpRequest) throws Exception {
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        int retryTimes = ParamConstant.RETRY_TIMES;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502) {
                    if (--retryTimes <= 0) {
                        log.warn((Object)("http status " + tStatusCode + ", and retry limit has been exceeded."));
                        LogUtil.saveHttpErrorLogToLMC(httpRequest.getMethod(), httpRequest.getURI().toString(), tResponse.getStatusLine().getStatusCode());
                        return tResponse;
                    }
                    log.warn((Object)("http status " + tStatusCode + ", waiting for retry..."));
                    try {
                        Thread.sleep(ParamConstant.RETRY_INTERVAL);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)e1);
                        return tResponse;
                    }
                }
                JsonObject tReturnJsonObject = null;
                try {
                    HttpEntity entity = tResponse.getEntity();
                    entity = new BufferedHttpEntity(entity);
                    tResponse.setEntity(entity);
                    tReturnJsonObject = JsonUtil.parseHttpResponseBody((HttpResponse)tResponse, null);
                }
                catch (Exception e) {
                    log.error((Object)"Http Response Body parse fail:{}", (Throwable)e);
                }
                if (null != tReturnJsonObject) {
                    HttpInvokeUtil.checkErrorCode(tReturnJsonObject);
                }
                return tResponse;
            }
            catch (InvocationException e) {
                throw e;
            }
            catch (NoHttpResponseException e) {
                log.warn((Object)"HTTP request NoHttpResponseException:{}", (Throwable)e);
                tClient = HttpClientFactory.reCreateHttpClient();
                retryTimes = HttpInvokeUtil.retryExceptionCheck(retryTimes, (Exception)((Object)e));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("HTTP request Exception:{}" + e));
                retryTimes = HttpInvokeUtil.retryExceptionCheck(retryTimes, e);
                continue;
            }
            break;
        }
    }

    private static int retryExceptionCheck(int retryTimes, Exception e) throws Exception {
        if (--retryTimes <= 0) {
            throw e;
        }
        try {
            Thread.sleep(ParamConstant.RETRY_INTERVAL);
        }
        catch (InterruptedException e1) {
            log.warn((Object)e1);
            throw e;
        }
        return retryTimes;
    }

    private static void checkErrorCode(JsonObject tReturnJsonObject) {
        JsonElement errorCodeE = tReturnJsonObject.get("errorCode");
        if (null != errorCodeE) {
            String errorCode = errorCodeE.getAsString();
            String errorMessage = tReturnJsonObject.get("errorMessage") == null ? "" : tReturnJsonObject.get("errorMessage").getAsString();
            JsonObject instructors = tReturnJsonObject.getAsJsonObject("errorInstructors");
            String chainInfo = "";
            if (null != instructors) {
                chainInfo = instructors.get("chainInfo") == null ? "" : instructors.get("chainInfo").getAsString();
            }
            throw new InvocationException(errorCode, errorMessage, chainInfo);
        }
    }

    @Deprecated
    public static HttpResponse executeHttpRequest(HttpUriRequest httpRequest) throws ClientProtocolException, IOException {
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        int retryTimes = ParamConstant.RETRY_TIMES;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502) {
                    if (--retryTimes <= 0) {
                        log.warn((Object)("http status " + tStatusCode + ", and retry limit has been exceeded."));
                        LogUtil.saveHttpErrorLogToLMC(httpRequest.getMethod(), httpRequest.getURI().toString(), tResponse.getStatusLine().getStatusCode());
                        return tResponse;
                    }
                    log.warn((Object)("http status " + tStatusCode + ", waiting for retry..."));
                    try {
                        Thread.sleep(ParamConstant.RETRY_INTERVAL);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)e1);
                        return tResponse;
                    }
                }
                return tResponse;
            }
            catch (Exception e) {
                log.warn((Object)e);
                if (--retryTimes <= 0) {
                    throw e;
                }
                try {
                    Thread.sleep(ParamConstant.RETRY_INTERVAL);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)e1);
                    throw e;
                }
            }
        }
    }
}

