/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.AbstractInvoker;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.dap.log.DapLogUtils;
import com.digiwin.athena.esp.sdk.dap.log.LogItemType;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapLogDto;
import com.digiwin.athena.esp.sdk.dap.log.service.DapLogService;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.LoadBalanceHttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.LogUtil;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.esp.ESPServerNameCacheUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.CollectionUtils;

public class DapInvoker
extends AbstractInvoker {
    private static Log log = LogFactory.getLog(DapInvoker.class);
    DapLogService dapLogService = new DapLogService();

    @Override
    protected String getTargetUrl(MessageModel messageModel) {
        String serviceId = ESPServerNameCacheUtil.getServiceId((String)messageModel.getRequestModel().getServiceName());
        messageModel.getRequestModel().setServiceProd(serviceId);
        log.info((Object)("DapInvoker selected service:" + serviceId));
        if (StringUtils.isBlank((CharSequence)serviceId) || StringUtils.isNotBlank((CharSequence)messageModel.getRequestModel().getServiceProd()) && !serviceId.equals(messageModel.getRequestModel().getServiceProd())) {
            return null;
        }
        List instances = ESPLoadBalanceUtil.getDiscoveryClient().getInstances(serviceId);
        if (CollectionUtils.isEmpty((Collection)instances)) {
            throw new RuntimeException("no service instance was found");
        }
        ServiceInstance serviceInstance = (ServiceInstance)instances.get(0);
        return "http://" + serviceId + "/" + (String)serviceInstance.getMetadata().get("eai.restfulPath");
    }

    @Override
    protected void execute(MessageModel messageModel) throws ClientProtocolException, IOException, ParseException, JsonFormatException {
        if (null != ESPLoadBalanceUtil.getDiscoveryProperties() && StringUtils.isNotBlank((CharSequence)ESPLoadBalanceUtil.getDiscoveryProperties().getService())) {
            messageModel.getRequestModel().setHostProd(ESPLoadBalanceUtil.getDiscoveryProperties().getService());
        }
        String tTargetUrl = this.getTargetUrl(messageModel);
        log.info((Object)("DapInvoker targetUrl:" + tTargetUrl));
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        Set<String> tKeySet = reqHeaders.keySet();
        for (String tKey : tKeySet) {
            if (reqHeaders.get(tKey) == null) continue;
            tHttpPost.setHeader(tKey, reqHeaders.get(tKey).toString());
        }
        StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        this.saveRequestLog(messageModel.getRequestModel().getTenantId(), reqHeaders, reqHeaders, messageModel.getRequestModel().getBodyJsonString());
        DapLogDto requestLog = DapLogUtils.getDapLog(messageModel, LogItemType.REQUEST, tTargetUrl, "");
        this.saveDapLog(requestLog);
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("espModel", (Object)messageModel);
        HttpResponse tHttpResponse = LoadBalanceHttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost, (HttpContext)httpContext);
        Integer tHttpStatus = tHttpResponse.getStatusLine().getStatusCode();
        Map<String, Object> resHeaders = this.getResponseHeaders(tHttpResponse, messageModel.getRequestModel());
        ResponseModel tResponseModel = new ResponseModel(resHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
        this.saveResponseLog(messageModel.getRequestModel().getTenantId(), reqHeaders, tHttpStatus, resHeaders, tResponseModel.getBodyJsonString());
        messageModel.setResponseModel(tResponseModel);
        DapLogDto responseLog = DapLogUtils.getDapLog(messageModel, LogItemType.RESPONSE, tTargetUrl, null != httpContext.getAttribute("serverIp") ? (String)httpContext.getAttribute("serverIp") : null);
        this.saveDapLog(responseLog);
    }

    private void saveDapLog(DapLogDto dapLogDto) {
        log.info((Object)("start save DapLog log:" + dapLogDto));
        try {
            this.dapLogService.savleLog(dapLogDto);
        }
        catch (Exception e) {
            log.error((Object)("save Dap log  error log:" + dapLogDto + ", e:{}"), (Throwable)e);
        }
    }

    @Override
    protected Map<String, Object> getRequestHeaders(RequestModel requestModel) throws ClientProtocolException, ParseException, IOException, JsonFormatException {
        String reqid = UUID.randomUUID().toString();
        requestModel.addHeader("digi-reqid", reqid);
        if (requestModel.getInvokeType().equals((Object)InvokeTypeEnum.FASYNC)) {
            String host = ESPLoadBalanceUtil.getDiscoveryProperties().getIp();
            String port = String.valueOf(ESPLoadBalanceUtil.getDiscoveryProperties().getPort());
            String callbackUrl = "http://" + host + ":" + port + ESPLoadBalanceUtil.getEaiCallbackPath();
            requestModel.addHeader("digi-callback-url", callbackUrl);
            requestModel.addHeader("digi-callback-parent-reqid", reqid);
            requestModel.addHeader("digi-callback-logurl", URLConstant.ESP_REST_BASE_URL + "/saveDapLogs");
        }
        Map<String, Object> headers = requestModel.getHttpHeaders();
        headers.remove("digi-middleware-auth-app");
        headers.remove("digi-key");
        return headers;
    }

    @Override
    protected Map<String, Object> getResponseHeaders(HttpResponse httpResponse, RequestModel requestModel) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (Header tHeader : httpResponse.getAllHeaders()) {
            headers.put(tHeader.getName(), tHeader.getValue());
        }
        headers.put("digi-reqid", requestModel.getHeader("digi-reqid"));
        headers.put("routerKey", requestModel.getTenantId());
        int status = httpResponse.getStatusLine().getStatusCode();
        if (String.valueOf(status).startsWith("2")) {
            if (requestModel.getInvokeType().equals((Object)InvokeTypeEnum.FASYNC)) {
                headers.put("digi-code", "0E9");
                headers.put("digi-message", "RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWFqOW8guatpeivt+axguaOpeaUtueKtuaAgQ==");
            } else {
                headers.put("digi-code", "019");
                headers.put("digi-message", "RUFJIFJlc3BvbnNlOuW5s+WPsOi/lOWbnuWQjOatpee7k+aenA==");
            }
        } else if (status == 404) {
            headers.put("digi-code", "311");
            headers.put("digi-message", "RUFJIFJlc3BvbnNlOuaXoOazleiBlOacuuiHs+i/nOeoi+acjeWKoQ==");
        } else {
            headers.put("digi-code", "322");
            headers.put("digi-message", "RUFJIFJlc3BvbnNlOui/nOeoi+acjeWKoeWPkeeUn+S+i+Wklg==");
        }
        return headers;
    }

    @Override
    protected void saveRequestLog(String tenantId, Map<String, Object> requestHeaders, Map<String, Object> headers, String messageBody) throws ClientProtocolException, IOException {
        LogUtil.saveLogToLMC("invoke", tenantId, requestHeaders, null, headers, messageBody, null);
    }

    @Override
    protected void saveResponseLog(String tenantId, Map<String, Object> requestHeaders, Integer httpStatus, Map<String, Object> headers, String messageBody) throws ClientProtocolException, IOException {
        LogUtil.saveLogToLMC("invokeRtn", tenantId, requestHeaders, httpStatus, headers, messageBody, null);
    }

    @Override
    protected void saveResponseErrorLog(String tenantId, Map<String, Object> requestHeaders, Exception ex) throws ClientProtocolException, IOException {
        LogUtil.saveLogToLMC("invokeRtn", tenantId, requestHeaders, null, null, null, ex);
    }
}

