/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.init;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.constants.DAPConstant;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.parameter.ApplicationParameter;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EspSdkInitialize {
    private static Log log = LogFactory.getLog(EspSdkInitialize.class);

    public static void initMQConfig(String mqUrl) {
        URLConstant.MQ_URL = mqUrl.trim();
    }

    public static void initAppConfig(String appid, String apptoken) {
        AppConstant.APP_ID = appid.trim();
        AppConstant.APP_TOKEN = apptoken.trim();
    }

    public static void initAppSecret(String appsecret) {
        AppConstant.APP_SECRET = appsecret.trim();
    }

    public static void setAppAuthExclude(String authExclude) {
        if (!StringUtil.isEmptyOrSpace(authExclude)) {
            AppConstant.APP_AUTH_EXCLUDE = authExclude.split(",");
        }
    }

    public static void initLmcConfig(String lmcUrl) {
        if (lmcUrl != null) {
            URLConstant.LMC_BASE_URL = lmcUrl.trim().startsWith("http") ? lmcUrl.trim() : "http://" + lmcUrl.trim();
        }
    }

    public static void enableEspRouting(Boolean value) {
        ApplicationParameter.setParameter("enableEspRouting", value);
    }

    public static void initConfig(String espDomain, String mdcDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, null, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String kmDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, kmDomain, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String kmDomain, String eocDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, kmDomain, eocDomain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initConfig(String espDomain, String mdcDomain, String kmDomain, String eocDomain, String iamDomain) {
        Class<EspSdkInitialize> clazz = EspSdkInitialize.class;
        synchronized (EspSdkInitialize.class) {
            if (espDomain != null) {
                if (espDomain.trim().startsWith("http")) {
                    URLConstant.ESP_REST_BASE_URL = espDomain.trim() + "/CROSS/RESTful";
                    URLConstant.ESPDP_BASE_URL = espDomain.trim().replaceFirst("esp", "espdp");
                } else {
                    URLConstant.ESP_REST_BASE_URL = "http://" + espDomain.trim() + "/CROSS/RESTful";
                    URLConstant.ESPDP_BASE_URL = "http://" + espDomain.trim().replaceFirst("esp", "espdp");
                }
            }
            if (mdcDomain != null) {
                URLConstant.MDC_BASE_URL = mdcDomain.trim().startsWith("http") ? mdcDomain.trim() : "http://" + mdcDomain.trim();
                if (mdcDomain.contains("esp")) {
                    URLConstant.MDC_BASE_URL = URLConstant.MDC_BASE_URL + "/ESP/MetadataCache";
                }
            }
            if (kmDomain != null) {
                URLConstant.TM_BASE_URL = kmDomain.trim().startsWith("http") ? kmDomain.trim() : "http://" + kmDomain.trim();
            }
            if (eocDomain != null) {
                URLConstant.EOC_BASE_URL = eocDomain.trim().startsWith("http") ? eocDomain.trim() : "http://" + eocDomain.trim();
            }
            if (iamDomain != null) {
                URLConstant.IAM_BASE_URL = iamDomain.trim().startsWith("http") ? iamDomain.trim() : "http://" + iamDomain.trim();
            }
            try {
                ClassLoader classLoader = EspSdkInitialize.deduceClassLoader();
                if (classLoader != null) {
                    classLoader.loadClass("com.digiwin.loadbalance.esp.ESPLoadBalanceUtil");
                    DAPConstant.LOADBALANCE_ENABLE = true;
                }
            }
            catch (ClassNotFoundException e) {
                DAPConstant.LOADBALANCE_ENABLE = false;
            }
            return;
        }
    }

    private static ClassLoader deduceClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = EspSdkInitialize.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static void initHttpParamConfig(Integer maxTotal, Integer defaultMaxPerroute, Integer connectTimeOut) {
        ParamConstant.CONNECT_TIME_OUT = connectTimeOut;
        ParamConstant.DEFAULT_MAX_PERROUTE = defaultMaxPerroute;
        ParamConstant.MAX_TOTAL = maxTotal;
    }

    public static void initRetryParamConfig(Integer retryTimes, Long retryInterval) {
        ParamConstant.RETRY_TIMES = retryTimes;
        ParamConstant.RETRY_INTERVAL = retryInterval;
    }
}

