/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.dap.log.service;

import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapLogDto;
import com.digiwin.athena.esp.sdk.util.DapLogHttpClientFactory;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.IfLastModified;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class DapLogService {
    private static Log log = LogFactory.getLog(DapLogService.class);
    private static final String PATH = URLConstant.ESP_REST_BASE_URL + "/saveDapLogs";
    private static ExecutorService executorService = new ThreadPoolExecutor(10, 30, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), (r, executor) -> log.error((Object)"Dap log send queue is full will discard current work !!!"));
    private static CloseableHttpClient httpClient;
    private static Logger dapLogLogger;
    private static DynamicDapLogLoggerInfo dapLogLoggerInfo;

    public DapLogService() {
        httpClient = DapLogHttpClientFactory.createHttpClient();
    }

    public static void initLogger(LoggerContext targetLoggerContext) {
        if (dapLogLogger != null) {
            log.warn((Object)"DapLogService.dapLogLogger is not null, you can not initialize logger twice!");
            return;
        }
        if (targetLoggerContext == null) {
            log.warn((Object)"DapLogService.initLogger(null), will use LoggerContext.getContext(false) return Context instead.");
            targetLoggerContext = LoggerContext.getContext((boolean)false);
        } else {
            log.info((Object)"DapLogService.initLogger ready to init Target LoggerContext...");
        }
        try {
            DynamicDapLogLoggerInfo dynamicDapLogLoggerInfo = DynamicDapLogLoggerInfo.createFilePathInfo();
            Configuration currentConfiguration = targetLoggerContext.getConfiguration();
            PatternLayout espLogLayout = PatternLayout.newBuilder().withConfiguration(currentConfiguration).withPattern("%msg%n").withCharset(Charset.forName("UTF-8")).build();
            String currentJVMFolderName = String.format("platform/log/esplog/", UUID.randomUUID().toString());
            TimeBasedTriggeringPolicy timeBasedTriggeringPolicy = TimeBasedTriggeringPolicy.newBuilder().build();
            SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = SizeBasedTriggeringPolicy.createPolicy((String)dynamicDapLogLoggerInfo.sizeBasedTriggeringPolicySize);
            CompositeTriggeringPolicy compositeTriggeringPolicy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{timeBasedTriggeringPolicy, sizeBasedTriggeringPolicy});
            IfFileName fileNameCondition = IfFileName.createNameCondition((String)dynamicDapLogLoggerInfo.deleteActionNameCondition, null, (PathCondition[])new PathCondition[0]);
            IfLastModified lastModifiedCondition = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)dynamicDapLogLoggerInfo.deleteActionLastModifiedAge), null);
            DeleteAction deleteAction = DeleteAction.createDeleteAction((String)dynamicDapLogLoggerInfo.deleteActionBasePath, (boolean)true, (int)1, (boolean)false, null, (PathCondition[])new PathCondition[]{fileNameCondition, lastModifiedCondition}, null, (Configuration)currentConfiguration);
            DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.newBuilder().withConfig(currentConfiguration).withCustomActions(new Action[]{deleteAction}).build();
            RollingFileAppender espLogRollingFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("espLogRollingFileAppender")).setConfiguration(currentConfiguration)).withFileName(dynamicDapLogLoggerInfo.logFileName).withFilePattern(dynamicDapLogLoggerInfo.rollingFilePattern).withPolicy((TriggeringPolicy)compositeTriggeringPolicy).withStrategy((RolloverStrategy)rolloverStrategy).setLayout((Layout)espLogLayout)).build();
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.FATAL, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.ERROR, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.WARN, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.INFO, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.DEBUG, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY));
            espLogRollingFileAppender.start();
            ConsoleAppender espLogConsoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("espLogConsoleAppender")).setConfiguration(currentConfiguration)).setLayout((Layout)espLogLayout)).build();
            espLogConsoleAppender.start();
            currentConfiguration.addAppender((Appender)espLogConsoleAppender);
            currentConfiguration.addAppender((Appender)espLogRollingFileAppender);
            AppenderRef consoleAppenderRef = AppenderRef.createAppenderRef((String)"espLogConsoleAppender", (Level)Level.INFO, null);
            AppenderRef rollingFileAppenderRef = AppenderRef.createAppenderRef((String)"espLogConsoleAppender", (Level)Level.INFO, null);
            AppenderRef[] appenderRefs = new AppenderRef[]{consoleAppenderRef, rollingFileAppenderRef};
            LoggerConfig espLogLoggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)dynamicDapLogLoggerInfo.loggerName, (String)"true", (AppenderRef[])appenderRefs, null, (Configuration)currentConfiguration, null);
            espLogLoggerConfig.addAppender((Appender)espLogConsoleAppender, Level.INFO, null);
            espLogLoggerConfig.addAppender((Appender)espLogRollingFileAppender, Level.INFO, null);
            currentConfiguration.addLogger(dynamicDapLogLoggerInfo.loggerName, espLogLoggerConfig);
            targetLoggerContext.updateLoggers();
            dapLogLogger = targetLoggerContext.getLogger(dynamicDapLogLoggerInfo.loggerName);
            dapLogLoggerInfo = dynamicDapLogLoggerInfo;
        }
        catch (Exception e) {
            log.error((Object)"DapLogService.initLogger failed!", (Throwable)e);
        }
    }

    protected void saveLogToFile(DapLogDto dapLogDto) {
        DapLogDto[] logArray = new DapLogDto[]{dapLogDto};
        String logContent = JsonUtil.toString(logArray);
        if (dapLogLogger == null) {
            log.warn((Object)"DapLogService.dapLogLogger is null, maybe you forgot to call EspSdkInitialize.initConfig method first?");
        } else {
            dapLogLogger.info(logContent);
        }
    }

    public void saveLog(DapLogDto dapLogDto) {
        if (dapLogLoggerInfo != null && dapLogLoggerInfo.isLoggerMode) {
            log.info((Object)"esp-sdk start to log Dap log to log4j logger...");
            this.saveLogToFile(dapLogDto);
            log.info((Object)"esp-sdk log Dap log completed.");
            return;
        }
        log.info((Object)("esp-sdk submit Dap log :" + dapLogDto));
        executorService.submit(() -> {
            boolean result = true;
            String path = URLConstant.ESP_REST_BASE_URL + "/saveDapLogs";
            log.info((Object)("esp-sdk start to send Dap log :" + dapLogDto + ", logpath:" + path));
            DapLogDto[] logArray = new DapLogDto[]{dapLogDto};
            HttpPost httpPost = new HttpPost(path);
            StringEntity stringEntity = new StringEntity(JsonUtil.toString(logArray), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
            try {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            catch (Exception e) {
                result = false;
                log.error((Object)("esp-sdk send Dap log  error log:" + dapLogDto + ", e:{}"), (Throwable)e);
            }
            if (result) {
                log.info((Object)("esp-sdk send Dap log success log :" + dapLogDto + ", logpath:" + path));
            }
        });
    }

    public static String getSystemOrEnvProperty(String key) {
        String systemValue = System.getProperty(key);
        if (systemValue == null || systemValue.isEmpty()) {
            return System.getenv(key);
        }
        return systemValue;
    }

    public static class DynamicDapLogLoggerInfo {
        public static final String KEY_IS_LOGGER_MODE = "espDapLogIsLoggerMode";
        public static final String KEY_FILE_PATH = "espDapLogFilePath";
        public static final String KEY_FILE_NAME_WITHOUT_EXTENSION = "espDapLogFileNameWithoutExtension";
        public static final String KEY_FILE_EXTENSION = "espDapLogFileExtension";
        public static final String KEY_SIZE_BASED_TRIGGERING_POLICY_SIZE = "espDapLogSizeBasedTriggeringPolicySize";
        public static final String KEY_SIZE_DELETE_ACTION_LAST_MODIFIED_AGE = "espDapLogDeleteActionLastModifiedAge";
        private boolean isLoggerMode = true;
        private String loggerName = "espDapLogLogger";
        private String logFilePath = "platform/log/esplog/";
        private String logFileNameWithoutExtension = "esp";
        private String logFileExtension = "log";
        private String logFileName;
        private String rollingFilePattern;
        private String deleteActionBasePath;
        private String deleteActionNameCondition;
        private String deleteActionLastModifiedAge = "7d";
        private String sizeBasedTriggeringPolicySize = "10MB";

        private void initLogPathBaseInfo() {
            DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_IS_LOGGER_MODE, "Is Logger Mode", customValue -> {
                this.isLoggerMode = Boolean.parseBoolean(customValue);
            });
            DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_SIZE_DELETE_ACTION_LAST_MODIFIED_AGE, "Delete action last modified age", customValue -> {
                this.deleteActionLastModifiedAge = customValue;
            });
            DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_FILE_PATH, "File Path", customValue -> {
                this.logFilePath = customValue;
            });
            DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_FILE_NAME_WITHOUT_EXTENSION, "File Name without extension", customValue -> {
                this.logFileNameWithoutExtension = customValue;
            });
            DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_FILE_EXTENSION, "File extension", customValue -> {
                this.logFileExtension = customValue;
            });
        }

        public static DynamicDapLogLoggerInfo createFilePathInfo() {
            DynamicDapLogLoggerInfo pathInfo = new DynamicDapLogLoggerInfo();
            pathInfo.initLogPathBaseInfo();
            String hostName = DapLogService.getSystemOrEnvProperty("HOSTNAME");
            if (hostName == null || hostName.isEmpty()) {
                hostName = DapLogService.getSystemOrEnvProperty("COMPUTERNAME");
            }
            log.info((Object)("> Host name = " + hostName));
            String actualLogFileNameWithoutExtension = pathInfo.logFileNameWithoutExtension;
            if (hostName != null || !hostName.isEmpty()) {
                actualLogFileNameWithoutExtension = String.format("%s_%s", actualLogFileNameWithoutExtension, hostName);
            }
            actualLogFileNameWithoutExtension = pathInfo.logFilePath + actualLogFileNameWithoutExtension;
            pathInfo.logFileName = actualLogFileNameWithoutExtension + "." + pathInfo.logFileExtension;
            pathInfo.rollingFilePattern = actualLogFileNameWithoutExtension + "-%d{yyyy-MM-dd}.%i." + pathInfo.logFileExtension;
            pathInfo.deleteActionBasePath = pathInfo.logFilePath;
            pathInfo.deleteActionNameCondition = pathInfo.logFileNameWithoutExtension + "*." + pathInfo.logFileExtension;
            DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_SIZE_BASED_TRIGGERING_POLICY_SIZE, "Size based triggering policy size", customValue -> {
                pathInfo.sizeBasedTriggeringPolicySize = customValue;
            });
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.isLoggerMode, "isLoggerMode");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.loggerName, "loggerName");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFilePath, "logFilePath");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFileNameWithoutExtension, "logFileNameWithoutExtension");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFileExtension, "logFileExtension");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFileName, "logFileName");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.rollingFilePattern, "rollingFilePattern");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.deleteActionBasePath, "deleteActionBasePath");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.deleteActionNameCondition, "deleteActionNameCondition");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.deleteActionLastModifiedAge, "deleteActionLastModifiedAge");
            DynamicDapLogLoggerInfo.logFieldValue(pathInfo.sizeBasedTriggeringPolicySize, "sizeBasedTriggeringPolicySize");
            return pathInfo;
        }

        private static void initCustomizableFieldValue(String propertyKey, String description, Consumer<String> customValueConsumer) {
            String customValue = DapLogService.getSystemOrEnvProperty(propertyKey);
            if (customValue != null && !customValue.isEmpty()) {
                customValueConsumer.accept(customValue);
                log.info((Object)String.format("esp-sdk Found custom ESP Dap Log - %s, variable %s = %s", description, propertyKey, customValue));
            }
        }

        private static void logFieldValue(Object value, String description) {
            log.info((Object)String.format(">esp-sdk Dap Log Logger - %s = %s", description, value));
        }
    }
}

