/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class MDCUtil {
    private static Log log = LogFactory.getLog(MDCUtil.class);
    private static final String MDC_APIMETADATA_GET = "/restful/standard/mdc/ApiMetadata/Get";

    public static boolean getApiIdempotency(String apiName, String tenantId) {
        String tURL = URLConstant.MDC_BASE_URL + MDC_APIMETADATA_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("api_name", apiName);
        if (!StringUtil.isEmpty(tenantId)) {
            tJsonObject.addProperty("tenant_id", tenantId);
        }
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
            JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
            return tReturnJsonObject.getAsJsonObject("data").get("idempotency").getAsBoolean();
        }
        catch (InvocationException e) {
            if (null != tenantId) {
                return MDCUtil.getApiIdempotency(apiName, null);
            }
        }
        catch (Exception e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]mdc get Api Idempotency fail;apiName:" + apiName + ", tenantId: " + tenantId + ", e:{}"), (Throwable)e);
        }
        return false;
    }

    public static String getParentServiceName(String serviceName) {
        return "";
    }
}

