/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.LoadBalanceHttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.dap.log.service.DapLogService;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.init.EspHttpClientConfig;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.LogUtil;
import com.digiwin.athena.esp.sdk.util.MDCUtil;
import com.google.gson.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public class LoadBalanceHttpInvokeUtil {
    private static Log log = LogFactory.getLog(LoadBalanceHttpInvokeUtil.class);
    private static DapLogService dapLogService = new DapLogService();

    private static CloseableHttpResponse executeHttpWithDapRetry(HttpUriRequest httpRequest, HttpContext httpContext, RequestModel requestModel) throws Exception {
        CloseableHttpClient tClient = EspHttpClientConfig.getLoadbalanceHttpClient();
        CloseableHttpResponse tResponse = tClient.execute(httpRequest, httpContext);
        JsonObject tReturnJsonObject = null;
        try {
            HttpEntity entity = tResponse.getEntity();
            entity = new BufferedHttpEntity(entity);
            tResponse.setEntity(entity);
            tReturnJsonObject = JsonUtil.parseHttpResponseBody((HttpResponse)tResponse, null);
        }
        catch (Exception e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]Http Response Body parse fail:{}"), (Throwable)e);
            HttpInvokeUtil.processParseException(httpRequest, (HttpResponse)tResponse);
        }
        if (null != tReturnJsonObject) {
            HttpInvokeUtil.checkErrorCode(tReturnJsonObject, HttpInvokeUtil.getReqId((HttpResponse)tResponse));
        }
        return tResponse;
    }

    private static CloseableHttpResponse executeHttp(HttpUriRequest httpRequest, HttpContext httpContext, RequestModel requestModel) throws Exception {
        if (!EspHttpClientConfig.isLegacyMode()) {
            return LoadBalanceHttpInvokeUtil.executeHttpWithDapRetry(httpRequest, httpContext, requestModel);
        }
        int noHttpResponseExceptionCount = 0;
        int maxNoHttpResponseExceptionRetryCount = 5;
        Boolean idempotence = null;
        CloseableHttpClient tClient = LoadBalanceHttpClientFactory.createHttpClient();
        int retryCount = ParamConstant.RETRY_COUNT;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest, httpContext)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502) {
                    if (idempotence == null) {
                        idempotence = MDCUtil.getApiIdempotency(requestModel.getServiceName(), requestModel.getTenantId());
                    }
                    if (--retryCount <= 0 || !idempotence.booleanValue()) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]http status " + tStatusCode + String.format(", [idempotence=%s, serviceName=%s, tenantId=%s]", idempotence, requestModel.getServiceName(), requestModel.getTenantId()) + ", and retry limit has been exceeded."));
                        LogUtil.saveHttpErrorLogToLMC(httpRequest.getMethod(), httpRequest.getURI().toString(), tResponse.getStatusLine().getStatusCode());
                        return tResponse;
                    }
                    log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]http status " + tStatusCode + String.format(", [idempotence=%s, serviceName=%s, tenantId=%s]", idempotence, requestModel.getServiceName(), requestModel.getTenantId()) + ", waiting for retry..."));
                    try {
                        Thread.sleep(ParamConstant.RETRY_INTERVAL);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + e1));
                        return tResponse;
                    }
                }
                JsonObject tReturnJsonObject = null;
                try {
                    HttpEntity entity = tResponse.getEntity();
                    entity = new BufferedHttpEntity(entity);
                    tResponse.setEntity(entity);
                    tReturnJsonObject = JsonUtil.parseHttpResponseBody((HttpResponse)tResponse, null);
                }
                catch (Exception e) {
                    log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]Http Response Body parse fail:{}"), (Throwable)e);
                    HttpInvokeUtil.processParseException(httpRequest, (HttpResponse)tResponse);
                }
                if (null != tReturnJsonObject) {
                    HttpInvokeUtil.checkErrorCode(tReturnJsonObject, HttpInvokeUtil.getReqId((HttpResponse)tResponse));
                }
                return tResponse;
            }
            catch (InvocationException e) {
                throw e;
            }
            catch (NoHttpResponseException e) {
                if (++noHttpResponseExceptionCount <= maxNoHttpResponseExceptionRetryCount) {
                    ++retryCount;
                }
                log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "][noHttpResponseExceptionCount = " + noHttpResponseExceptionCount + "]LoadBalanceHttpInvokeUtil HTTP request NoHttpResponseException:{}"), (Throwable)e);
                retryCount = HttpInvokeUtil.retryExceptionCheck(retryCount, (Exception)((Object)e));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]LoadBalanceHttpInvokeUtil HTTP request Exception:{}" + e));
                retryCount = HttpInvokeUtil.retryExceptionCheck(retryCount, e);
                continue;
            }
            break;
        }
    }

    public static HttpResponse executeHttpRequest(HttpUriRequest httpRequest, HttpContext httpContext, RequestModel requestModel) throws Exception {
        return LoadBalanceHttpInvokeUtil.executeHttp(httpRequest, httpContext, requestModel);
    }
}

