/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.configuration;

import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.http.client.ESPHttpAPIInfoProvider;
import com.digiwin.athena.esp.sdk.http.client.ESPLoadBalanceRequestRetryHandlerWrapper;
import com.digiwin.athena.esp.sdk.init.EspHttpClientConfig;
import com.digiwin.http.client.DWAPIResponseRetryStrategy;
import com.digiwin.http.client.DWDefaultAPIResponseRetryStrategy;
import com.digiwin.http.client.DWDefaultHttpRequestRetryHandler;
import com.digiwin.http.client.DWHTTPHostAppIdMapMapper;
import com.digiwin.http.client.DWHTTPHostAppIdMapper;
import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.DWHttpRetryProperties;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.client.config.DWHttpAPIInfoProvider;
import com.digiwin.http.client.config.DWHttpRetryConfigProvider;
import com.digiwin.http.client.config.apollo.DWApolloHttpAPIInfoProvider;
import com.digiwin.http.context.DWLoadBalanceUtils;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DWHttpTargetEAIServiceInfo.class, DWHTTPHostAppIdMapper.class, DWHttpRetryManager.class, DWDefaultHttpRequestRetryHandler.class, DWApolloHttpAPIInfoProvider.class, DWHttpRetryConfigProvider.class, DWHttpRetryProperties.class})
@ConditionalOnProperty(name={"espDAPHttpRetryEnabled"}, havingValue="true", matchIfMissing=true)
public class ESPHttpClientWithDAPRetryConfiguration {
    private static Log log = LogFactory.getLog(ESPHttpClientWithDAPRetryConfiguration.class);

    @Bean(value={"esp-sdk-dw-httpclient-retry-manager"})
    public DWHttpRetryManager getESPHttpRetryManager(DWHttpRetryConfigProvider retryConfigProvider, ObjectProvider<DWHTTPHostAppIdMapper> hostAppIdMapperObjectProvider, ObjectProvider<DWHttpRetryProperties> retryPropertiesObjectProvider) {
        DWHttpRetryProperties retryProperties;
        log.info((Object)"ESPHttpClientWithDAPRetryConfiguration start to init esp-sdk HttpClient object...");
        DWHTTPHostAppIdMapper hostAppIdMapper = (DWHTTPHostAppIdMapper)hostAppIdMapperObjectProvider.getIfAvailable();
        if (hostAppIdMapper == null) {
            log.warn((Object)"ESPHttpClientWithDAPRetryConfiguration can not find DWHTTPHostAppIdMapper bean in the environment, use emptyMap instead!");
            hostAppIdMapper = new DWHTTPHostAppIdMapMapper(Collections.emptyMap());
        }
        if ((retryProperties = (DWHttpRetryProperties)retryPropertiesObjectProvider.getIfAvailable()) == null) {
            retryProperties = new DWHttpRetryProperties();
            log.warn((Object)"ESPHttpClientWithDAPRetryConfiguration can not find DWHttpRetryProperties bean in the environment, use default instance instead!");
            log.info((Object)(">>> isEaiAPIDefaultConfigEnabled = " + retryProperties.isEaiAPIDefaultConfigEnabled()));
            log.info((Object)(">>> isGeneralAPIDefaultConfigEnabled = " + retryProperties.isGeneralAPIDefaultConfigEnabled()));
            log.info((Object)(">>> isGeneralAPIUserConfigCheckIdempotence = " + retryProperties.isUserConfigCheckIdempotence()));
        }
        boolean requiredBeanExists = true;
        if (retryConfigProvider == null) {
            log.warn((Object)String.format("ESPHttpClientWithDAPRetryConfiguration required bean(class=%s) is not exist!", DWHttpRetryConfigProvider.class.getName()));
            requiredBeanExists = false;
        }
        ESPHttpAPIInfoProvider apiInfoProvider = new ESPHttpAPIInfoProvider();
        DWHttpRetryManager espRetryManager = new DWHttpRetryManager(retryConfigProvider, (DWHttpAPIInfoProvider)apiInfoProvider, hostAppIdMapper, retryProperties);
        DWDefaultHttpRequestRetryHandler requestRetryHandler = new DWDefaultHttpRequestRetryHandler(espRetryManager);
        DWDefaultAPIResponseRetryStrategy responseRetryStrategy = new DWDefaultAPIResponseRetryStrategy(espRetryManager);
        if (requiredBeanExists) {
            log.info((Object)"ESPHttpClientWithDAPRetryConfiguration init esp-sdk HTTPCleint...");
            this.initDefaultHttpClient((HttpRequestRetryHandler)requestRetryHandler, (DWAPIResponseRetryStrategy)responseRetryStrategy);
            this.initLoadBalanceHttpClient((HttpRequestRetryHandler)requestRetryHandler, (DWAPIResponseRetryStrategy)responseRetryStrategy);
            EspHttpClientConfig.setLegacyMode(false);
            log.info((Object)"ESPHttpClientWithDAPRetryConfiguration init esp-sdk HttpClient object completed!");
        } else {
            log.warn((Object)"ESPHttpClientWithDAPRetryConfiguration required bean is not exist, esp-sdk will use legacy http invocation mode!");
        }
        return espRetryManager;
    }

    private void initDefaultHttpClient(HttpRequestRetryHandler requestRetryHandler, DWAPIResponseRetryStrategy responseRetryStrategy) {
        PoolingHttpClientConnectionManager connManager;
        try {
            SSLContext sslContext = SSLContexts.custom().build();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            connManager = new PoolingHttpClientConnectionManager(registry);
        }
        catch (Exception e) {
            connManager = new PoolingHttpClientConnectionManager();
        }
        connManager.setMaxTotal(200 >= ParamConstant.MAX_TOTAL ? 200 : ParamConstant.MAX_TOTAL);
        connManager.setDefaultMaxPerRoute(100 >= ParamConstant.DEFAULT_MAX_PERROUTE ? 100 : ParamConstant.DEFAULT_MAX_PERROUTE);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        if (null != ParamConstant.CONNECT_TIME_OUT) {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).setConnectTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).setConnectionRequestTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
        }
        httpClientBuilder.setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)responseRetryStrategy);
        EspHttpClientConfig.setDefaultHttpClient(httpClientBuilder.build());
    }

    private void initLoadBalanceHttpClient(HttpRequestRetryHandler requestRetryHandler, DWAPIResponseRetryStrategy responseRetryStrategy) {
        PoolingHttpClientConnectionManager connManager;
        try {
            SSLContext sslContext = SSLContexts.custom().build();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            connManager = new PoolingHttpClientConnectionManager(registry);
        }
        catch (Exception e) {
            connManager = new PoolingHttpClientConnectionManager();
        }
        connManager.setMaxTotal(200);
        connManager.setDefaultMaxPerRoute(100);
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setRoutePlanner((target, request, context) -> {
            DWLoadBalanceUtils.setLoadBalanceFlag((boolean)true);
            HttpRoute httpRoute = ESPLoadBalanceUtil.getDwRoutePlanner().determineRoute(target, request, context);
            context.setAttribute("serverIp", (Object)httpRoute.getTargetHost().getHostName());
            return httpRoute;
        }).setRetryHandler((HttpRequestRetryHandler)new ESPLoadBalanceRequestRetryHandlerWrapper(requestRetryHandler)).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)responseRetryStrategy).build();
        EspHttpClientConfig.setLoadbalanceHttpClient(closeableHttpClient);
    }
}

