/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.connection;

import com.digiwin.athena.esp.sdk.constants.DAPConstant;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import com.digiwin.http.context.DWLoadBalanceUtils;
import com.digiwin.loadbalance.client.httpclient.DWHttpClientBuild;
import com.digiwin.loadbalance.client.httpclient.DWMainExecWrapper;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.springframework.cloud.client.ServiceInstance;

public class LoadBalanceHttpClientFactory {
    private static Log log = LogFactory.getLog(LoadBalanceHttpClientFactory.class);
    private static CloseableHttpClient closeableHttpClient;

    public static HttpClientBuilder getLoadblanceClientBuildWithRoutePlan() {
        EspSdkInitialize.initLoadbalanceReouteConfig();
        HttpClientBuilder httpClientBuilder = null;
        httpClientBuilder = DAPConstant.LOADBALANCE_ENABLE && DAPConstant.SUPPORT_REROUTE && null != ESPLoadBalanceUtil.getDwMainExecWrapper() ? DWHttpClientBuild.create((DWMainExecWrapper)ESPLoadBalanceUtil.getDwMainExecWrapper()).setRoutePlanner(ESPLoadBalanceUtil.getDwRerouteRoutePlanner()) : HttpClients.custom().setRoutePlanner((target, request, context) -> {
            DWLoadBalanceUtils.setLoadBalanceFlag((boolean)true);
            HttpRoute httpRoute = ESPLoadBalanceUtil.getDwRoutePlanner().determineRoute(target, request, context);
            context.setAttribute("serverIp", (Object)httpRoute.getTargetHost().getHostName());
            return httpRoute;
        });
        return httpClientBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient createHttpClient() {
        Class<LoadBalanceHttpClientFactory> clazz = LoadBalanceHttpClientFactory.class;
        synchronized (LoadBalanceHttpClientFactory.class) {
            if (closeableHttpClient == null) {
                PoolingHttpClientConnectionManager connManager;
                try {
                    SSLContext sslContext = SSLContexts.custom().build();
                    SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                    Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
                    connManager = new PoolingHttpClientConnectionManager(registry);
                }
                catch (Exception e) {
                    connManager = new PoolingHttpClientConnectionManager();
                }
                connManager.setMaxTotal(200);
                connManager.setDefaultMaxPerRoute(100);
                HttpClientBuilder httpClientBuilder = null;
                httpClientBuilder = DAPConstant.SUPPORT_REROUTE && null != ESPLoadBalanceUtil.getDwMainExecWrapper() ? LoadBalanceHttpClientFactory.getLoadblanceClientBuildWithRoutePlan().setRetryHandler((exception, executionCount, context) -> {
                    HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                    RouteInfo httpRoute = clientContext.getHttpRoute();
                    log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]retryhostname:" + httpRoute.getTargetHost().getHostName() + ", executionCount:" + clientContext));
                    if (executionCount <= ParamConstant.RETRY_COUNT) {
                        try {
                            Thread.sleep(ParamConstant.RETRY_INTERVAL);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]fail to retry after retryInterval " + ParamConstant.RETRY_INTERVAL), (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        return true;
                    }
                    return false;
                }) : LoadBalanceHttpClientFactory.getLoadblanceClientBuildWithRoutePlan().setRetryHandler((exception, executionCount, context) -> {
                    HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                    RouteInfo httpRoute = clientContext.getHttpRoute();
                    String targetHostName = httpRoute.getTargetHost().getHostName();
                    int port = httpRoute.getTargetHost().getPort();
                    String appName = clientContext.getTargetHost().getHostName();
                    log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]retryhostname:" + appName));
                    Optional<ServiceInstance> targetInstance = ESPLoadBalanceUtil.getDiscoveryClient().getInstances(appName).stream().filter(instance -> instance.getHost().equals(targetHostName) && instance.getPort() == port).findFirst();
                    if (targetInstance.isPresent()) {
                        Map metadata = targetInstance.get().getMetadata();
                        if (StringUtils.isNumeric((CharSequence)((CharSequence)metadata.get("eai.hostRetryTimes"))) && executionCount <= Integer.valueOf((String)metadata.get("eai.hostRetryTimes"))) {
                            if (StringUtils.isNumeric((CharSequence)((CharSequence)metadata.get("eai.hostRetryInterval")))) {
                                try {
                                    Thread.sleep(Long.valueOf((String)metadata.get("eai.hostRetryInterval")));
                                }
                                catch (InterruptedException e) {
                                    log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]fail to retry after retryInterval " + (String)metadata.get("eai.hostRetryInterval")), (Throwable)e);
                                    Thread.currentThread().interrupt();
                                }
                            }
                            return true;
                        }
                    } else if (executionCount <= ParamConstant.RETRY_COUNT) {
                        try {
                            Thread.sleep(ParamConstant.RETRY_INTERVAL);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]fail to retry after retryInterval " + ParamConstant.RETRY_INTERVAL), (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                        return true;
                    }
                    return false;
                });
                closeableHttpClient = httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connManager).build();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return closeableHttpClient;
        }
    }
}

