/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.dap.log;

import com.digiwin.athena.esp.sdk.dap.log.LogItemType;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapLogDto;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapRequest;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapService;
import com.digiwin.athena.esp.sdk.dap.log.dto.LogItem;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.util.CompressUtil;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DapLogUtils {
    public static DapLogDto getRequestDapLog(MessageModel messageModel, Map<String, Object> requestHeaders, String targetUrl, String serverIp) {
        Map<String, String> stringValueRequestHeaders = null;
        if (requestHeaders != null) {
            stringValueRequestHeaders = requestHeaders.entrySet().stream().filter(item -> item.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        }
        return DapLogUtils.getDapLog(messageModel, stringValueRequestHeaders, LogItemType.REQUEST, targetUrl, serverIp);
    }

    public static DapLogDto getDapLog(MessageModel messageModel, LogItemType logItemType, String targetUrl, String serverIp) {
        return DapLogUtils.getDapLog(messageModel, null, logItemType, targetUrl, serverIp);
    }

    public static DapLogDto getDapLog(MessageModel messageModel, Map<String, String> requestHeaders, LogItemType logItemType, String targetUrl, String serverIp) {
        DapLogDto dapLogDto = new DapLogDto();
        dapLogDto.setReq_id(messageModel.getRequestModel().getHeader("digi-reqid"));
        DapRequest request = new DapRequest();
        request.setAp_name(messageModel.getRequestModel().getHostProd());
        request.setVersion(messageModel.getRequestModel().getHostVer());
        request.setId(messageModel.getRequestModel().getHostId());
        request.setUid("");
        if (null != ESPLoadBalanceUtil.getDiscoveryProperties() && StringUtils.isNotBlank((CharSequence)ESPLoadBalanceUtil.getDiscoveryProperties().getIp())) {
            ESPLoadBalanceUtil.getDiscoveryProperties().getIp();
        }
        request.setAp_user(messageModel.getRequestModel().getHostAcct());
        request.setTimestamp(String.valueOf(System.currentTimeMillis()));
        dapLogDto.setRequest(request);
        DapService service = new DapService();
        service.setAp_name(messageModel.getRequestModel().getServiceProd());
        service.setVersion("");
        service.setIp(serverIp);
        service.setUid("");
        service.setId("");
        service.setTenant_id(messageModel.getRequestModel().getTenantId());
        service.setService_name(messageModel.getRequestModel().getServiceName());
        dapLogDto.setService(service);
        LogItem logItem = null;
        switch (logItemType) {
            case REQUEST: {
                logItem = DapLogUtils.createLogItem("D00", "1", targetUrl, requestHeaders != null ? requestHeaders : messageModel.getRequestModel().getHeaderMap(), messageModel.getRequestModel().getBodyJsonString());
                break;
            }
            case RESPONSE: {
                String digiCode = messageModel.getResponseModel().getHeader("digi-code");
                String statusCode = digiCode == null || digiCode.isEmpty() ? "019" : digiCode;
                logItem = DapLogUtils.createLogItem(statusCode, "2", targetUrl, messageModel.getResponseModel().getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    if (null == entry.getValue()) {
                        return "";
                    }
                    return entry.getValue().toString();
                }, (o1, o2) -> o2)), messageModel.getResponseModel().getBodyJsonString());
                break;
            }
        }
        dapLogDto.setLogs(new LogItem[]{logItem});
        return dapLogDto;
    }

    public static LogItem createLogItem(String stateCode, String priority, String targetUrl, Map<String, String> headers, String bodyString) {
        LogItem logItem = new LogItem();
        logItem.setState_code(stateCode);
        logItem.setPlatform_time(String.valueOf(System.currentTimeMillis()));
        logItem.setLog_display_priority(priority);
        logItem.setUrl(targetUrl);
        logItem.setHeaders(headers);
        logItem.setData_key("");
        logItem.setBody(CompressUtil.compress(bodyString));
        return logItem;
    }
}

