/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.http.client;

import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.client.ServiceInstance;

public class ESPLoadBalanceRequestRetryHandlerWrapper
implements HttpRequestRetryHandler {
    private static Log log = LogFactory.getLog(ESPLoadBalanceRequestRetryHandlerWrapper.class);
    private HttpRequestRetryHandler sourceRetryHandler;

    public ESPLoadBalanceRequestRetryHandlerWrapper(HttpRequestRetryHandler source) {
        this.sourceRetryHandler = source;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        RouteInfo httpRoute = clientContext.getHttpRoute();
        String targetHostName = httpRoute.getTargetHost().getHostName();
        int port = httpRoute.getTargetHost().getPort();
        String appName = clientContext.getTargetHost().getHostName();
        log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]retryhostname:" + appName));
        Optional<ServiceInstance> targetInstance = ESPLoadBalanceUtil.getDiscoveryClient().getInstances(appName).stream().filter(instance -> instance.getHost().equals(targetHostName) && instance.getPort() == port).findFirst();
        if (!targetInstance.isPresent()) {
            return false;
        }
        return this.sourceRetryHandler.retryRequest(exception, executionCount, context);
    }
}

