/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.configuration;

import com.digiwin.athena.esp.sdk.connection.LoadBalanceHttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.http.client.ESPHttpAPIInfoProvider;
import com.digiwin.athena.esp.sdk.http.client.ESPLoadBalanceRequestRetryHandlerWrapper;
import com.digiwin.athena.esp.sdk.init.EspHttpClientConfig;
import com.digiwin.http.client.DWAPIResponseRetryStrategy;
import com.digiwin.http.client.DWDefaultAPIResponseRetryStrategy;
import com.digiwin.http.client.DWDefaultHttpRequestRetryHandler;
import com.digiwin.http.client.DWHTTPHostAppIdMapMapper;
import com.digiwin.http.client.DWHTTPHostAppIdMapper;
import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.DWHttpRetryProperties;
import com.digiwin.http.client.DWHttpTargetEAIServiceInfo;
import com.digiwin.http.client.config.DWHttpAPIInfoProvider;
import com.digiwin.http.client.config.DWHttpRetryConfigProvider;
import com.digiwin.http.client.config.apollo.DWApolloHttpAPIInfoProvider;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DWHttpTargetEAIServiceInfo.class, DWHTTPHostAppIdMapper.class, DWHttpRetryManager.class, DWDefaultHttpRequestRetryHandler.class, DWApolloHttpAPIInfoProvider.class, DWHttpRetryConfigProvider.class, DWHttpRetryProperties.class})
@ConditionalOnProperty(name={"espDAPHttpRetryEnabled"}, havingValue="true", matchIfMissing=true)
public class ESPHttpClientWithDAPRetryConfiguration {
    private static Log log = LogFactory.getLog(ESPHttpClientWithDAPRetryConfiguration.class);

    public ESPHttpClientWithDAPRetryConfiguration(ApplicationContext applicationContext) {
        String maxTotalString = applicationContext.getEnvironment().getProperty("espHttpClientMaxTotal");
        String maxPerRouteString = applicationContext.getEnvironment().getProperty("espHttpClientDefaultMaxPerRoute");
        String connectTimeoutString = applicationContext.getEnvironment().getProperty("espHttpClientConnectTimeout");
        log.info((Object)"ESPHttpClientWithDAPRetryConfiguration http client config");
        log.info((Object)("espHttpClientMaxTotal = " + maxTotalString));
        log.info((Object)("espHttpClientDefaultMaxPerRoute = " + maxPerRouteString));
        log.info((Object)("espHttpClientConnectTimeout = " + connectTimeoutString));
        if (maxTotalString != null) {
            ParamConstant.MAX_TOTAL = Integer.parseInt(maxTotalString);
        }
        if (maxPerRouteString != null) {
            ParamConstant.DEFAULT_MAX_PERROUTE = Integer.parseInt(maxPerRouteString);
        }
        if (connectTimeoutString != null) {
            ParamConstant.CONNECT_TIME_OUT = Integer.parseInt(connectTimeoutString);
        }
    }

    @Bean(value={"esp-sdk-dw-httpclient-retry-manager"})
    public DWHttpRetryManager getESPHttpRetryManager(ApplicationContext applicationContext, DWHttpRetryConfigProvider retryConfigProvider, ObjectProvider<DWHTTPHostAppIdMapper> hostAppIdMapperObjectProvider, ObjectProvider<DWHttpRetryProperties> retryPropertiesObjectProvider, ObjectProvider<ESPLoadBalanceUtil> espLoadBalanceUtilProvider, ObjectProvider<List<HttpRoutePlanner>> httpRoutePlannerList) {
        DWHttpRetryProperties retryProperties;
        log.info((Object)"ESPHttpClientWithDAPRetryConfiguration start to init esp-sdk HttpClient object...");
        try {
            httpRoutePlannerList.getIfAvailable();
            espLoadBalanceUtilProvider.getIfAvailable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DWHTTPHostAppIdMapper hostAppIdMapper = (DWHTTPHostAppIdMapper)hostAppIdMapperObjectProvider.getIfAvailable();
        if (hostAppIdMapper == null) {
            log.warn((Object)"ESPHttpClientWithDAPRetryConfiguration can not find DWHTTPHostAppIdMapper bean in the environment, use emptyMap instead!");
            hostAppIdMapper = new DWHTTPHostAppIdMapMapper(Collections.emptyMap());
        }
        if ((retryProperties = (DWHttpRetryProperties)retryPropertiesObjectProvider.getIfAvailable()) == null) {
            retryProperties = new DWHttpRetryProperties();
            log.warn((Object)"ESPHttpClientWithDAPRetryConfiguration can not find DWHttpRetryProperties bean in the environment, use default instance instead!");
            log.info((Object)(">>> isEaiAPIDefaultConfigEnabled = " + retryProperties.isEaiAPIDefaultConfigEnabled()));
            log.info((Object)(">>> isGeneralAPIDefaultConfigEnabled = " + retryProperties.isGeneralAPIDefaultConfigEnabled()));
            log.info((Object)(">>> isGeneralAPIUserConfigCheckIdempotence = " + retryProperties.isUserConfigCheckIdempotence()));
        }
        boolean requiredBeanExists = true;
        if (retryConfigProvider == null) {
            log.warn((Object)String.format("ESPHttpClientWithDAPRetryConfiguration required bean(class=%s) is not exist!", DWHttpRetryConfigProvider.class.getName()));
            requiredBeanExists = false;
        }
        ESPHttpAPIInfoProvider apiInfoProvider = new ESPHttpAPIInfoProvider();
        DWHttpRetryManager espRetryManager = new DWHttpRetryManager(retryConfigProvider, (DWHttpAPIInfoProvider)apiInfoProvider, hostAppIdMapper, retryProperties);
        DWDefaultHttpRequestRetryHandler requestRetryHandler = new DWDefaultHttpRequestRetryHandler(espRetryManager);
        DWDefaultAPIResponseRetryStrategy responseRetryStrategy = new DWDefaultAPIResponseRetryStrategy(espRetryManager);
        if (requiredBeanExists) {
            log.info((Object)"ESPHttpClientWithDAPRetryConfiguration init esp-sdk HTTPCleint...");
            this.initDefaultHttpClient(applicationContext, (HttpRequestRetryHandler)requestRetryHandler, (DWAPIResponseRetryStrategy)responseRetryStrategy);
            this.initLoadBalanceHttpClient(applicationContext, (HttpRequestRetryHandler)requestRetryHandler, (DWAPIResponseRetryStrategy)responseRetryStrategy);
            EspHttpClientConfig.setLegacyMode(false);
            log.info((Object)"ESPHttpClientWithDAPRetryConfiguration init esp-sdk HttpClient object completed!");
        } else {
            log.warn((Object)"ESPHttpClientWithDAPRetryConfiguration required bean is not exist, esp-sdk will use legacy http invocation mode!");
        }
        return espRetryManager;
    }

    private void initDefaultHttpClient(ApplicationContext applicationContext, HttpRequestRetryHandler requestRetryHandler, DWAPIResponseRetryStrategy responseRetryStrategy) {
        PoolingHttpClientConnectionManager connManager;
        try {
            SSLContext sslContext = SSLContexts.custom().build();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            connManager = new PoolingHttpClientConnectionManager(registry);
        }
        catch (Exception e) {
            connManager = new PoolingHttpClientConnectionManager();
        }
        connManager.setMaxTotal(200 >= ParamConstant.MAX_TOTAL ? 200 : ParamConstant.MAX_TOTAL);
        connManager.setDefaultMaxPerRoute(100 >= ParamConstant.DEFAULT_MAX_PERROUTE ? 100 : ParamConstant.DEFAULT_MAX_PERROUTE);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        if (null != ParamConstant.CONNECT_TIME_OUT) {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).setConnectTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).setConnectionRequestTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
        }
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)responseRetryStrategy).build();
        CloseableHttpClient maybeSpringBean = this.tryToBuildSpringBean(applicationContext, closeableHttpClient);
        EspHttpClientConfig.setDefaultHttpClient(maybeSpringBean);
    }

    private void initLoadBalanceHttpClient(ApplicationContext applicationContext, HttpRequestRetryHandler requestRetryHandler, DWAPIResponseRetryStrategy responseRetryStrategy) {
        PoolingHttpClientConnectionManager connManager;
        try {
            SSLContext sslContext = SSLContexts.custom().build();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            connManager = new PoolingHttpClientConnectionManager(registry);
        }
        catch (Exception e) {
            connManager = new PoolingHttpClientConnectionManager();
        }
        connManager.setMaxTotal(200 >= ParamConstant.MAX_TOTAL ? 200 : ParamConstant.MAX_TOTAL);
        connManager.setDefaultMaxPerRoute(100 >= ParamConstant.DEFAULT_MAX_PERROUTE ? 100 : ParamConstant.DEFAULT_MAX_PERROUTE);
        HttpClientBuilder httpClientBuilder = LoadBalanceHttpClientFactory.getLoadblanceClientBuildWithRoutePlan();
        if (null != ParamConstant.CONNECT_TIME_OUT) {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).setConnectTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).setConnectionRequestTimeout(ParamConstant.CONNECT_TIME_OUT.intValue()).build();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
        }
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connManager).setRetryHandler((HttpRequestRetryHandler)new ESPLoadBalanceRequestRetryHandlerWrapper(requestRetryHandler)).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)responseRetryStrategy).build();
        CloseableHttpClient maybeSpringBean = this.tryToBuildSpringBean(applicationContext, closeableHttpClient);
        EspHttpClientConfig.setLoadbalanceHttpClient(maybeSpringBean);
    }

    private CloseableHttpClient tryToBuildSpringBean(ApplicationContext applicationContext, CloseableHttpClient sourceHttpClient) {
        Object maybeSpringBean = sourceHttpClient;
        String httpclientApplyBeanEnabled = applicationContext.getEnvironment().getProperty("espDAPHttpClientApplyBeanEnabled", "true");
        String lookupToTopParentAppContext = applicationContext.getEnvironment().getProperty("espDAPHttpClientApplyBeanUseTopAppContext", "true");
        log.info((Object)("espDAPHttpClientApplyBeanEnabled = " + httpclientApplyBeanEnabled));
        log.info((Object)("espDAPHttpClientApplyBeanUseTopAppContext = " + httpclientApplyBeanEnabled));
        if (Boolean.TRUE.equals(Boolean.parseBoolean(httpclientApplyBeanEnabled))) {
            log.info((Object)String.format(">> current application context(id=%s) = %s", applicationContext.getId(), applicationContext));
            if (Boolean.TRUE.equals(Boolean.parseBoolean(lookupToTopParentAppContext))) {
                ApplicationContext parentContext = applicationContext.getParent();
                while (parentContext != null && parentContext.getParent() != null) {
                    applicationContext = parentContext;
                    parentContext = applicationContext.getParent();
                }
            }
            log.info((Object)String.format(">> final application context(id=%s) = %s", applicationContext.getId(), applicationContext));
            try {
                maybeSpringBean = applicationContext.getAutowireCapableBeanFactory().applyBeanPostProcessorsAfterInitialization((Object)sourceHttpClient, "esp-sdk-httpclient-source");
            }
            catch (Throwable e) {
                log.error((Object)"Can not apply DAP HttpClient to Spring Bean!", e);
            }
        }
        return maybeSpringBean;
    }
}

