/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.athena.esp.sdk.constants.DAPConstant;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.esp.ESPServerNameCacheUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class DAPSelectInvokeType {
    private static Log log = LogFactory.getLog(DAPSelectInvokeType.class);
    public static final String ACTIVE_REGION_SUFIX = "ar";
    public static final String TENANT_REGION_SUFIX = "tr";
    public static final String APOLLO_FILE_NAME_SPLIT = "_";
    private static final Map<String, String> preMapActive = new HashMap<String, String>();
    public static ThreadLocal<String> targProdNameThreadLocal;

    public static boolean canDapInvoke(MessageModel messageModel) {
        String targetAppName;
        if (DAPConstant.LOADBALANCE_ENABLE && ESPLoadBalanceUtil.getloadBalanceEnable() && StringUtils.isNotBlank((CharSequence)messageModel.getRequestModel().getServiceProd()) && StringUtils.isNotBlank((CharSequence)(targetAppName = DAPSelectInvokeType.searchEaiServiceId(messageModel.getRequestModel().getServiceName(), messageModel.getRequestModel().getServiceProd())))) {
            targProdNameThreadLocal.set(targetAppName);
            if (InvokeTypeEnum.SYNC.equals((Object)messageModel.getRequestModel().getInvokeType())) {
                return DAPSelectInvokeType.invokePreFilter(targetAppName, messageModel);
            }
            if (StringUtils.isBlank((CharSequence)messageModel.getRequestModel().getHeader("digi-callback-callback"))) {
                return DAPSelectInvokeType.invokePreFilter(targetAppName, messageModel);
            }
            if (StringUtils.isNotBlank((CharSequence)DAPSelectInvokeType.searchEaiServiceId(messageModel.getRequestModel().getHeader("digi-callback-callback"), StringUtils.isBlank((CharSequence)messageModel.getRequestModel().getHostProd()) ? ESPLoadBalanceUtil.getDwDiscoveryProperties().getRegisterName() : messageModel.getRequestModel().getHostProd()))) {
                return DAPSelectInvokeType.invokePreFilter(targetAppName, messageModel);
            }
        }
        return false;
    }

    public static boolean invokePreFilter(String proName, MessageModel messageModel) {
        if (!DAPSelectInvokeType.isPreOnly(proName)) {
            return true;
        }
        String espRequestTenantId = null;
        try {
            espRequestTenantId = ESPLoadBalanceUtil.getESPRequestTenantId(messageModel.getRequestModel().getHttpHeaders());
        }
        catch (Exception e) {
            log.info((Object)("judge dap invokePreFilter faile  " + e));
        }
        if (StringUtils.isBlank((CharSequence)espRequestTenantId)) {
            return false;
        }
        Config activeRegion_config = ConfigService.getConfig((String)(proName + APOLLO_FILE_NAME_SPLIT + ACTIVE_REGION_SUFIX));
        if (CollectionUtils.isEmpty((Collection)activeRegion_config.getPropertyNames())) {
            return false;
        }
        for (String appImageName : activeRegion_config.getPropertyNames()) {
            String activeRegion = activeRegion_config.getProperty(appImageName, "");
            String preRegion = preMapActive.get(activeRegion);
            if (StringUtils.isBlank((CharSequence)preRegion)) {
                return false;
            }
            Config tenant_region_config = ConfigService.getConfig((String)(proName + APOLLO_FILE_NAME_SPLIT + appImageName + APOLLO_FILE_NAME_SPLIT + TENANT_REGION_SUFIX));
            String preTenantIds = tenant_region_config.getProperty(preRegion, "");
            List<String> preTenantIdList = Arrays.asList(preTenantIds.split(","));
            if (preTenantIdList.contains(espRequestTenantId)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPreOnly(String proName) {
        Config config = ConfigService.getConfig((String)(proName + "_pre"));
        return "true".equals(config.getProperty(proName, "false"));
    }

    public static String searchEaiServiceId(String eaiId, String proName) {
        try {
            return ESPServerNameCacheUtil.serarchEaiAppNameWithOrder((String)eaiId, (String)proName);
        }
        catch (Throwable e) {
            log.error((Object)"DAPSelectInvokeType search searchEaiServiceId fail", e);
            return null;
        }
    }

    static {
        preMapActive.put("a", "b");
        preMapActive.put("b", "a");
        targProdNameThreadLocal = new ThreadLocal();
    }
}

