/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.constants.DAPConstant;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.dap.spi.ProdNameTransformService;
import com.digiwin.athena.esp.sdk.dap.util.DAPUtil;
import com.digiwin.athena.esp.sdk.enums.EocTypeEnum;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.digiwin.athena.esp.sdk.model.EocDispatchInfoModel;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.CompressUtil;
import com.digiwin.athena.esp.sdk.util.DAPSelectInvokeType;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.loadbalance.esp.ESPLoadBalanceUtil;
import com.digiwin.loadbalance.esp.ESPServerNameCacheUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.util.CollectionUtils;

public class EocOmTransformUtil {
    private static Log log = LogFactory.getLog(EocOmTransformUtil.class);
    private static final String PATH_DAP_MDC_TENANT_PRODUCT_OPERATION_LIST_GET = "/restful/standard/mdc/TenantProductOperationList/Get";
    private static final String PATH_DAP_MDC_TENANT_PRODUCT_OPERATION_LIST_V2_GET = "/restful/standard/mdc/TenantProductOperationListV2/Get";
    private static final String PATH_MDC_TENANT_PRODUCT_API_DISPATCH_INFO_GET = "/restful/standard/mdc/TenantProductApiDispatchInfo/Get";
    private static final String PATH_MDC_SERVICE_BASE_INFO_GET = "/restful/standard/mdc/ServiceBaseInfo/get";
    private static final String PATH_MDC_TENANT_INFO_GET = "/restful/standard/mdc/TenantInfo/Get";
    private static final String PATH_EOC_EMP_ID = "/api/eoc/v2/emp/id";
    private static final String PATH_TM_QUERY_EXECUTION_INFO_GET = "/restful/service/knowledgegraph/action/queryExecutionInfo";
    private static final String REGULAR = "[\"'](ex_){0,1}(eoc|om)_(company|site|region)_id[\"']\\s*:\\s*[\"'].+[\"']";
    private static final String REGULAR_V2 = "[\"'](ops_unit_no|om_(company|site|region)_id)[\"']\\s*:\\s*[\"'].+[\"']";
    private static final String REGULAR_OPS_UNIT_NO_V2 = "[\"']ops_unit_no[\"']\\s*:\\s*[\"']([^\"']*)[\"']";
    private static final String EOC_TAG_REGEX = ".*_(eoc|om)_(company|region)_id";
    private static final String DATAKEY = "datakey";
    private static final String UID = "uid";
    private static final String REGION_TYPE = "region_type";
    private static final String EX_REGION_TYPE = "ex_region_type";
    private static final String KEY_HEADER_CHAIN_INFO = "digi-dap-service-chain-info";
    private static final String KEY_HEADER_SECURITY_TOKEN = "security-token";
    private static final String KEY_HEADER_ROUTER_KEY = "routerKey";
    private static final String KEY_HEADER_APP_TOKEN = "digi-middleware-auth-app";
    private static final String KEY_HEADER_APP_SECRET = "digi-middleware-auth-app-secret";
    private static final String KEY_HEADER_USER_TOKEN = "digi-middleware-auth-user";
    private static final String KEY_HEADER_TOKEN = "token";
    private static final String KEY_HEADER_DIGI_TOKEN = "digi-token";
    private static final String BASE_INFO_KEY_PROD = "prod";
    private static final String BASE_INFO_KEY_API = "api";
    private static final String BASE_INFO_KEY_EOC = "eoc";
    private static final String BASE_INFO_KEY_DISPATCH = "dispatch";
    private static final String PRODUCT_TYPE_AGILE = "agile";

    public static String uncompressAndTransform(String message, String tenantId, Map<String, ?> headers) throws Exception {
        JsonParser tJsonParser = new JsonParser();
        JsonObject tCompressHeaderJsonObject = null;
        String tProd = null;
        try {
            tCompressHeaderJsonObject = headers.get("digi-compressed") != null ? tJsonParser.parse(headers.get("digi-compressed").toString()).getAsJsonObject() : null;
            tProd = tCompressHeaderJsonObject != null && tCompressHeaderJsonObject.get("source_prod") != null ? tCompressHeaderJsonObject.get("source_prod").getAsString() : null;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        if (tCompressHeaderJsonObject == null) {
            log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]Cannot uncompress: compressed info not found."));
            return message;
        }
        JsonObject tMessageJsonObject = tJsonParser.parse(message).getAsJsonObject();
        String msg = CompressUtil.uncompress(tMessageJsonObject.get("std_data").getAsJsonObject().get("parameter").getAsJsonObject().get("compressed_data").getAsString());
        tMessageJsonObject.get("std_data").getAsJsonObject().add("parameter", tJsonParser.parse(msg));
        if (tProd == null) {
            log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]Cannot transform om to eoc: source product info not found."));
            return tMessageJsonObject.toString();
        }
        return EocOmTransformUtil.transform(tMessageJsonObject.toString(), tenantId, tProd);
    }

    public static String transform(String message, String tenantId, String product) throws Exception {
        return EocOmTransformUtil.transform(message, tenantId, product, null);
    }

    public static String transform(String message, String tenantId, String product, String uid) throws Exception {
        JsonObject tMappingJsonObject;
        if (EocOmTransformUtil.checkTransform(message) && EocOmTransformUtil.hasTransformInfo(tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product, null, uid, null, null))) {
            return EocOmTransformUtil.transform(message, tMappingJsonObject, null);
        }
        return message;
    }

    public static String transformByServiceName(String message, String tenantId, String serviceName, String userToken) throws Exception {
        JsonObject tActionExecutionInfoJsonObject = EocOmTransformUtil.getActionExecutionInfo(tenantId, serviceName, userToken, null, null);
        String tProd = tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("productName").getAsString();
        if (StringUtil.isEmptyOrSpace(tProd)) {
            throw new TenantInfoNotFoundException(String.format("Service product is empty or space. KnowledgeMap host:[%s], tenantId:[%s], api:[%s]", URLConstant.TM_BASE_URL, tenantId, serviceName));
        }
        return EocOmTransformUtil.transform(message, tenantId, tProd);
    }

    public static String transformByServiceName(String message, String tenantId, String serviceName, String userToken, String securityToken) throws Exception {
        JsonObject tActionExecutionInfoJsonObject = EocOmTransformUtil.getActionExecutionInfo(tenantId, serviceName, userToken, null, securityToken);
        String tProd = tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("productName").getAsString();
        if (StringUtil.isEmptyOrSpace(tProd)) {
            throw new TenantInfoNotFoundException(String.format("Service product is empty or space. KnowledgeMap host:[%s], tenantId:[%s], api:[%s]", URLConstant.TM_BASE_URL, tenantId, serviceName));
        }
        return EocOmTransformUtil.transform(message, tenantId, tProd);
    }

    private static void tryTransformRequestModel(MessageModel messageModel) {
        RequestModel requestModel = messageModel.getRequestModel();
        if (StringUtils.isNotBlank((CharSequence)requestModel.getServiceProd()) && DAPConstant.LOADBALANCE_ENABLE && ESPLoadBalanceUtil.getloadBalanceEnable()) {
            String originalServiceProd = requestModel.getServiceProd();
            String originalHostProd = requestModel.getHostProd();
            requestModel.setServiceProd(ProdNameTransformService.transform(originalServiceProd));
            requestModel.setHostProd(ESPLoadBalanceUtil.getDwDiscoveryProperties().getRegisterName());
            if (DAPSelectInvokeType.canDapInvoke(messageModel)) {
                return;
            }
            requestModel.setHostProd(originalHostProd);
            requestModel.setServiceProd(originalServiceProd);
        }
    }

    public static void transformRequest(MessageModel messageModel) throws Exception {
        RequestModel requestModel = messageModel.getRequestModel();
        EocOmTransformUtil.richMDCProdNameFromCache(messageModel);
        boolean hasServiceProd = StringUtils.isNotBlank((CharSequence)requestModel.getServiceProd());
        EocOmTransformUtil.tryTransformRequestModel(messageModel);
        if (DAPSelectInvokeType.canDapInvoke(messageModel)) {
            return;
        }
        boolean isNeedDispatchInfo = EocOmTransformUtil.isNeedDispatch(messageModel);
        JsonObject baseInfo = EocOmTransformUtil.getBaseInfo(messageModel, isNeedDispatchInfo, true);
        if (JsonUtil.isNull(baseInfo.get(BASE_INFO_KEY_PROD))) {
            throw new TenantInfoNotFoundException(String.format("Service product is empty or space. MDC host:[%s], tenantId:[%s], api:[%s]", URLConstant.MDC_BASE_URL, requestModel.getTenantId(), requestModel.getServiceName()));
        }
        JsonObject productInfo = JsonUtil.getJsonObjectPropFromJson(baseInfo, BASE_INFO_KEY_PROD, null);
        String prodName = JsonUtil.getStringPropFromJson(productInfo, "name", null);
        String prodUid = JsonUtil.getStringPropFromJson(productInfo, UID, null);
        String productType = JsonUtil.getStringPropFromJson(productInfo, "productType", null);
        boolean isAgile = PRODUCT_TYPE_AGILE.equals(productType);
        requestModel.setServiceProd(prodName);
        requestModel.setServiceProdUid(prodUid);
        Boolean idempotency = JsonUtil.getBooleanPropFromJson(baseInfo, BASE_INFO_KEY_API, "idempotency");
        requestModel.setIdempotency(BooleanUtils.isTrue((Boolean)idempotency));
        EocOmTransformUtil.changeServiceName(requestModel, baseInfo);
        if (isAgile) {
            if (!hasServiceProd) {
                EocOmTransformUtil.cacheMDCProdName(messageModel);
                EocOmTransformUtil.tryTransformRequestModel(messageModel);
            }
            return;
        }
        EocOmTransformUtil.transformAcct(requestModel);
        JsonObject mappingJsonObject = JsonUtil.getJsonObjectPropFromJson(baseInfo, BASE_INFO_KEY_EOC, null);
        messageModel.setEocMappingJsonObject(mappingJsonObject);
        String version = baseInfo.get("tenantVersion").getAsString();
        requestModel.setTenantVersion(version);
        if ("v2".equalsIgnoreCase(version)) {
            JsonObject jsonObject;
            ArrayList enterpriseList = new ArrayList();
            JsonArray orgTypeMapping = mappingJsonObject.getAsJsonArray("org_type_mapping");
            orgTypeMapping.forEach(x -> {
                JsonObject mapping = x.getAsJsonObject();
                if ("enterprise_id".equals(mapping.get("type").getAsString())) {
                    enterpriseList.add(mapping);
                }
            });
            if (!CollectionUtils.isEmpty(enterpriseList) && (jsonObject = (JsonObject)enterpriseList.get(0)).has(DATAKEY)) {
                requestModel.addDatakey(jsonObject.get(DATAKEY).getAsString(), jsonObject.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
            }
            if (EocOmTransformUtil.hasTransformInfoV2(mappingJsonObject)) {
                String tBody;
                Map<String, Object> tEocMapV2 = messageModel.getRequestModel().getEocMap();
                if (tEocMapV2 != null && !tEocMapV2.isEmpty()) {
                    if (requestModel.getDatakeyMap() == null) {
                        requestModel.setDatakeyMap(new HashMap<String, String>());
                    }
                    EocOmTransformUtil.eocTransformToDataKeyV2(requestModel.getDatakeyMap(), tEocMapV2, mappingJsonObject);
                    if (requestModel.getOmMap() == null) {
                        requestModel.setOmMap(new HashMap<String, Object>());
                    }
                    EocOmTransformUtil.transformEocOmMapV2(requestModel.getOmMap(), tEocMapV2, mappingJsonObject);
                }
                if (EocOmTransformUtil.checkTransformV2(tBody = messageModel.getRequestModel().getBodyJsonString())) {
                    requestModel.setBodyJsonString(EocOmTransformUtil.transformV2(tBody, mappingJsonObject, requestModel));
                }
            }
            EocOmTransformUtil.setDispatchInfoV2(messageModel, baseInfo);
        } else {
            JsonObject tEntObject;
            if (!JsonUtil.isNull(mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag())) && (tEntObject = mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag()).getAsJsonObject()).has(DATAKEY)) {
                requestModel.addDatakey(tEntObject.get(DATAKEY).getAsString(), tEntObject.get(EocTypeEnum.ENTERPRISE.getOmTag()).getAsString());
            }
            if (EocOmTransformUtil.hasTransformInfo(mappingJsonObject)) {
                String tBody;
                Map<String, Object> tEocMap = messageModel.getRequestModel().getEocMap();
                if (tEocMap != null && !tEocMap.isEmpty()) {
                    if (requestModel.getDatakeyMap() == null) {
                        requestModel.setDatakeyMap(new HashMap<String, String>());
                    }
                    EocOmTransformUtil.transformDatakey(requestModel.getDatakeyMap(), tEocMap, mappingJsonObject);
                    if (requestModel.getOmMap() == null) {
                        requestModel.setOmMap(new HashMap<String, Object>());
                    }
                    EocOmTransformUtil.transformEocOmMapObject(requestModel.getOmMap(), tEocMap, mappingJsonObject);
                }
                if (EocOmTransformUtil.checkTransform(tBody = messageModel.getRequestModel().getBodyJsonString())) {
                    requestModel.setBodyJsonString(EocOmTransformUtil.transform(tBody, mappingJsonObject, requestModel));
                }
            }
            EocOmTransformUtil.setDispatchInfo(messageModel, baseInfo);
        }
    }

    private static boolean changeServiceName(RequestModel requestModel, JsonObject baseInfo) {
        String parentServiceName = JsonUtil.getStringPropFromJson(baseInfo, BASE_INFO_KEY_API, "parentApi");
        if (StringUtils.isNotBlank((CharSequence)parentServiceName)) {
            log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "] service name " + requestModel.getServiceName() + " change " + parentServiceName));
            requestModel.setServiceName(parentServiceName);
            Map<String, String> dateKeyMap = requestModel.getDatakeyMap();
            if (null == dateKeyMap) {
                dateKeyMap = new HashMap<String, String>();
            }
            dateKeyMap.put("sub_api_name", requestModel.getServiceName());
            requestModel.setDatakeyMap(dateKeyMap);
            return true;
        }
        return false;
    }

    public static void transformResponse(MessageModel messageModel) throws Exception {
        ResponseModel resposeModel = messageModel.getResponseModel();
        RequestModel requestModel = messageModel.getRequestModel();
        String tBody = resposeModel.getBodyJsonString();
        if (StringUtils.isNotBlank((CharSequence)requestModel.getTenantVersion()) && "v2".equalsIgnoreCase(requestModel.getTenantVersion())) {
            if (EocOmTransformUtil.checkTransformV2(tBody)) {
                String tenantId = messageModel.getRequestModel().getTenantId();
                String product = messageModel.getRequestModel().getServiceProd();
                if (messageModel.getEocMappingJsonObject() == null) {
                    messageModel.setEocMappingJsonObject(EocOmTransformUtil.getMappingJsonObjectV2(tenantId, product));
                }
                if (EocOmTransformUtil.hasTransformInfoV2(messageModel.getEocMappingJsonObject())) {
                    resposeModel.setBodyJsonString(EocOmTransformUtil.transformV2(tBody, messageModel.getEocMappingJsonObject(), null));
                }
            }
        } else if (EocOmTransformUtil.checkTransform(tBody)) {
            String tenantId = messageModel.getRequestModel().getTenantId();
            String product = messageModel.getRequestModel().getServiceProd();
            String uid = messageModel.getRequestModel().getServiceProdUid();
            if (messageModel.getEocMappingJsonObject() == null) {
                String dapChain = messageModel.getRequestModel().getHeader(KEY_HEADER_CHAIN_INFO);
                String securityToken = messageModel.getRequestModel().getHeader(KEY_HEADER_SECURITY_TOKEN);
                messageModel.setEocMappingJsonObject(EocOmTransformUtil.getMappingJsonObject(tenantId, product, null, uid, dapChain, securityToken));
            }
            if (EocOmTransformUtil.hasTransformInfo(messageModel.getEocMappingJsonObject())) {
                resposeModel.setBodyJsonString(EocOmTransformUtil.transform(tBody, messageModel.getEocMappingJsonObject(), null));
            }
        }
    }

    private static void transformAcct(RequestModel requestModel) throws Exception {
        String tUserId = requestModel.getHostAcct();
        if (tUserId != null && !tUserId.trim().equals("")) {
            if (tUserId.trim().equals("athena")) {
                if (StringUtil.isEmpty(requestModel.getHostEmpAcct())) {
                    String serviceProd;
                    switch (serviceProd = requestModel.getServiceProd()) {
                        case "E10": {
                            requestModel.setHostEmpAcct("dcms");
                            break;
                        }
                        case "WFGP": {
                            requestModel.setHostEmpAcct("DS");
                            break;
                        }
                        case "T100": 
                        case "TIPTOP": {
                            requestModel.setHostEmpAcct("tiptop");
                            break;
                        }
                        default: {
                            requestModel.setHostEmpAcct(tUserId);
                            break;
                        }
                    }
                }
            } else {
                HttpResponse tHttpResponse;
                JsonObject tReturnJsonObject;
                String tURL = URLConstant.EOC_BASE_URL + PATH_EOC_EMP_ID;
                HttpPost tHttpPost = new HttpPost(tURL);
                JsonObject tJsonObject = new JsonObject();
                tJsonObject.addProperty("userId", tUserId.trim());
                StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
                tHttpPost.setEntity((HttpEntity)tStringEntity);
                tHttpPost.addHeader(KEY_HEADER_USER_TOKEN, requestModel.getHeader(KEY_HEADER_TOKEN));
                tHttpPost.addHeader(KEY_HEADER_ROUTER_KEY, requestModel.getTenantId());
                if (requestModel.getHeader(KEY_HEADER_CHAIN_INFO) != null) {
                    tHttpPost.addHeader(KEY_HEADER_CHAIN_INFO, requestModel.getHeader(KEY_HEADER_CHAIN_INFO));
                }
                if (requestModel.getHeader(KEY_HEADER_SECURITY_TOKEN) != null) {
                    tHttpPost.addHeader(KEY_HEADER_SECURITY_TOKEN, requestModel.getHeader(KEY_HEADER_SECURITY_TOKEN));
                }
                if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
                    tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
                } else if (requestModel.getHeader(KEY_HEADER_APP_TOKEN) != null) {
                    tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, requestModel.getHeader(KEY_HEADER_APP_TOKEN));
                }
                if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
                    tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
                }
                if ((tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost), tURL)).get("code") != null && tReturnJsonObject.get("code").getAsString().equals("200")) {
                    requestModel.setHostEmpAcct(tReturnJsonObject.get("data").getAsString());
                } else {
                    String tCode = null;
                    String tErrorMessage = null;
                    if (tReturnJsonObject.get("code") != null) {
                        tCode = tReturnJsonObject.get("code").getAsString();
                    }
                    if (tReturnJsonObject.get("errorMessage") != null) {
                        tErrorMessage = tReturnJsonObject.get("errorMessage").getAsString();
                    }
                    throw new Exception(String.format("EmpId not found. EOC host:[%s], user id:[%s], user token:[%s], response code:[%s], error message:[%s]", URLConstant.EOC_BASE_URL, tUserId, requestModel.getHeader(KEY_HEADER_TOKEN), tCode, tErrorMessage));
                }
            }
        }
    }

    private static String getCurrentTenantVersion(String tenantId) throws Exception {
        JsonObject tenantInfo = EocOmTransformUtil.getTenantInfo(tenantId);
        return tenantInfo.get("version").getAsString();
    }

    private static JsonObject getTenantInfo(String tenantId) throws Exception {
        String tURL = URLConstant.MDC_BASE_URL + PATH_MDC_TENANT_INFO_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("tenant_id", tenantId.trim());
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader(KEY_HEADER_ROUTER_KEY, tenantId);
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
        return JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
    }

    private static void transformDatakey(Map<String, String> datakeys, Map<String, Object> eocmap, JsonObject mappingJsonObject) {
        EocOmTransformUtil.transformDatakey(datakeys, eocmap, mappingJsonObject, EocTypeEnum.COMPANY);
        EocOmTransformUtil.transformDatakey(datakeys, eocmap, mappingJsonObject, EocTypeEnum.REGION);
    }

    private static void eocTransformToDataKeyV2(Map<String, String> dataKeys, Map<String, Object> eocmap, JsonObject mappingJsonObject) {
        String eocMappingId = null;
        Map value = (Map)eocmap.get("operation_unit_v2");
        if (value != null && value.get("eoc_mapping_id") != null) {
            eocMappingId = (String)value.get("eoc_mapping_id");
        }
        Object opsUnitNo = eocmap.get("ops_unit_no");
        if (StringUtils.isBlank(eocMappingId) && opsUnitNo != null) {
            eocMappingId = (String)eocmap.get("ops_unit_no");
        }
        if (eocMappingId == null) {
            return;
        }
        JsonArray orgTypeMapping = mappingJsonObject.getAsJsonArray("org_type_mapping");
        String finalEocMappingId = eocMappingId;
        orgTypeMapping.forEach(item -> {
            JsonObject itemObj = (JsonObject)item;
            if (itemObj.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString().equals(finalEocMappingId) && itemObj.has(DATAKEY) && (itemObj.get("type").getAsString().equals("company_id") || itemObj.get("type").getAsString().equals("site_id") || itemObj.get("type").getAsString().equals("region_id"))) {
                dataKeys.put(itemObj.get(DATAKEY).getAsString(), itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
            }
        });
    }

    private static void transformDatakey(Map<String, String> datakeys, Map<String, Object> eocmap, JsonObject mappingJsonObject, EocTypeEnum eocType) {
        if (eocmap.get(eocType.getEocTag()) != null) {
            JsonObject tSubObj;
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(eocType.getEocTag(), (String)eocmap.get(eocType.getEocTag()));
            if (eocType.equals((Object)EocTypeEnum.REGION) && eocmap.get(REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, (String)eocmap.get(REGION_TYPE));
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null && tSubObj.has(DATAKEY)) {
                datakeys.put(tSubObj.get(DATAKEY).getAsString(), tSubObj.get(eocType.getOmTag()).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transformDatakey(datakeys, eocmap, tSubObj, EocTypeEnum.SITE);
                }
            }
        }
    }

    public static Map<String, String> transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, String tenantId, String product) throws Exception {
        return EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tenantId, product, null, null);
    }

    public static Map<String, String> transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, String tenantId, String product, String dapChain, String securityToken) throws Exception {
        if (!sourceMap.isEmpty()) {
            String version = EocOmTransformUtil.getCurrentTenantVersion(tenantId);
            if ("v1".equalsIgnoreCase(version)) {
                JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product, null, null, dapChain, securityToken);
                EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tMappingJsonObject);
            } else {
                JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObjectV2(tenantId, product);
                EocOmTransformUtil.transformOmEocMapV2(targetMap, sourceMap, tMappingJsonObject);
            }
        }
        return targetMap;
    }

    private static void transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, JsonObject mappingJsonObject) {
        EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, mappingJsonObject, EocTypeEnum.COMPANY);
        EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, mappingJsonObject, EocTypeEnum.REGION);
    }

    private static void transformEocOmMapObject(Map<String, Object> targetMap, Map<String, Object> sourceMap, JsonObject mappingJsonObject) {
        EocOmTransformUtil.transformEocOmMapObject(targetMap, sourceMap, mappingJsonObject, EocTypeEnum.COMPANY);
        EocOmTransformUtil.transformEocOmMapObject(targetMap, sourceMap, mappingJsonObject, EocTypeEnum.REGION);
    }

    private static void transformEocOmMapV2(Map<String, Object> targetMap, Map<String, Object> sourceMap, JsonObject mappingJsonObject) {
        String eocMappingId = null;
        Map value = (Map)sourceMap.get("operation_unit_v2");
        if (value != null && value.get("eoc_mapping_id") != null) {
            eocMappingId = (String)value.get("eoc_mapping_id");
        }
        Object opsUnitNo = sourceMap.get("ops_unit_no");
        if (StringUtils.isBlank(eocMappingId) && opsUnitNo != null) {
            eocMappingId = (String)sourceMap.get("ops_unit_no");
        }
        if (eocMappingId == null) {
            return;
        }
        JsonArray orgTypeMapping = mappingJsonObject.getAsJsonArray("org_type_mapping");
        String finalEocMappingId = eocMappingId;
        orgTypeMapping.forEach(item -> {
            JsonObject itemObj = (JsonObject)item;
            if (itemObj.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString().equals(finalEocMappingId)) {
                if (itemObj.get("type").getAsString().equals("company_id")) {
                    targetMap.put(EocTypeEnum.COMPANY.getOmTag(), itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
                } else if (itemObj.get("type").getAsString().equals("site_id")) {
                    targetMap.put(EocTypeEnum.SITE.getOmTag(), itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
                } else if (itemObj.get("type").getAsString().equals("region_id")) {
                    targetMap.put(EocTypeEnum.REGION.getOmTag(), itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
                }
            }
        });
    }

    private static void transformOmEocMapV2(Map<String, String> targetMap, Map<String, String> sourceMap, JsonObject mappingJsonObject) {
        JsonArray orgTypeMapping = mappingJsonObject.getAsJsonArray("org_type_mapping");
        HashMap omMap = new HashMap();
        orgTypeMapping.forEach(item -> {
            JsonObject itemObj = (JsonObject)item;
            omMap.put(itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString(), itemObj);
        });
        sourceMap.forEach((k, v) -> {
            JsonObject omObject = (JsonObject)omMap.get(v);
            if (omObject != null) {
                if (omObject.get("type").getAsString().equals("company_id")) {
                    targetMap.put(EocTypeEnum.COMPANY.getEocTag(), omObject.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString());
                } else if (omObject.get("type").getAsString().equals("site_id")) {
                    targetMap.put(EocTypeEnum.SITE.getEocTag(), omObject.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString());
                } else if (omObject.get("type").getAsString().equals("region_id")) {
                    targetMap.put(EocTypeEnum.REGION.getEocTag(), omObject.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString());
                }
            }
        });
    }

    private static String transform(String message, JsonObject mappingJsonObject, RequestModel requestModel) {
        JsonParser tJsonParser = new JsonParser();
        JsonObject tMessageJsonObject = tJsonParser.parse(message).getAsJsonObject();
        EocOmTransformUtil.transform(tMessageJsonObject, mappingJsonObject, requestModel);
        return tMessageJsonObject.toString();
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject, RequestModel requestModel) {
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.COMPANY, requestModel);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.REGION, null);
        LinkedHashMap<String, String> tMap = new LinkedHashMap<String, String>();
        Set tKeySet = messageJsonObject.keySet();
        for (String tKey : tKeySet) {
            String tTypeKey;
            String tSiteKey;
            if (messageJsonObject.get(tKey).isJsonArray()) {
                JsonArray tJsonArray = messageJsonObject.get(tKey).getAsJsonArray();
                for (int i = 0; i < tJsonArray.size(); ++i) {
                    if (!tJsonArray.get(i).isJsonObject()) continue;
                    EocOmTransformUtil.transform(tJsonArray.get(i).getAsJsonObject(), mappingJsonObject, requestModel);
                }
                continue;
            }
            if (messageJsonObject.get(tKey).isJsonObject()) {
                EocOmTransformUtil.transform(messageJsonObject.get(tKey).getAsJsonObject(), mappingJsonObject, requestModel);
                continue;
            }
            if (!tKey.matches(EOC_TAG_REGEX) || JsonUtil.isNullOrEmptyOrSpace(messageJsonObject.get(tKey))) continue;
            HashMap<String, String> tCondition = new HashMap<String, String>();
            if (tKey.endsWith("eoc_company_id")) {
                tCondition.put("eoc_company_id", messageJsonObject.get(tKey).getAsString());
                JsonObject tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, EocTypeEnum.COMPANY, tCondition);
                if (tSubObj == null) continue;
                tMap.put(tKey.replace("eoc_company_id", "om_company_id"), tSubObj.get("om_company_id").getAsString());
                tSiteKey = tKey.replace("eoc_company_id", "eoc_site_id");
                if (JsonUtil.isNullOrEmptyOrSpace(messageJsonObject.get(tSiteKey))) continue;
                tCondition.clear();
                tCondition.put("eoc_site_id", messageJsonObject.get(tSiteKey).getAsString());
                if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(tSubObj, EocTypeEnum.SITE, tCondition)) == null) continue;
                tMap.put(tSiteKey.replace("eoc_site_id", "om_site_id"), tSubObj.get("om_site_id").getAsString());
                continue;
            }
            if (tKey.endsWith("om_company_id")) {
                tCondition.put("om_company_id", messageJsonObject.get(tKey).getAsString());
                JsonObject tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, EocTypeEnum.COMPANY, tCondition);
                if (tSubObj == null) continue;
                tMap.put(tKey.replace("om_company_id", "eoc_company_id"), tSubObj.get("eoc_company_id").getAsString());
                tSiteKey = tKey.replace("om_company_id", "om_site_id");
                if (JsonUtil.isNullOrEmptyOrSpace(messageJsonObject.get(tSiteKey))) continue;
                tCondition.clear();
                tCondition.put("om_site_id", messageJsonObject.get(tSiteKey).getAsString());
                if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(tSubObj, EocTypeEnum.SITE, tCondition)) == null) continue;
                tMap.put(tSiteKey.replace("om_site_id", "eoc_site_id"), tSubObj.get("eoc_site_id").getAsString());
                continue;
            }
            if (tKey.endsWith("eoc_region_id")) {
                JsonObject tSubObj;
                tCondition.put("eoc_region_id", messageJsonObject.get(tKey).getAsString());
                tTypeKey = tKey.replace("eoc_region_id", REGION_TYPE);
                if (!JsonUtil.isNullOrEmptyOrSpace(messageJsonObject.get(tTypeKey))) {
                    tCondition.put(REGION_TYPE, messageJsonObject.get(tTypeKey).getAsString());
                }
                if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, EocTypeEnum.REGION, tCondition)) == null) continue;
                tMap.put(tKey.replace("eoc_region_id", "om_region_id"), tSubObj.get("om_region_id").getAsString());
                continue;
            }
            if (!tKey.endsWith("om_region_id")) continue;
            tCondition.put("om_region_id", messageJsonObject.get(tKey).getAsString());
            tTypeKey = tKey.replace("om_region_id", REGION_TYPE);
            JsonObject tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, EocTypeEnum.REGION, tCondition);
            if (tSubObj == null || JsonUtil.isNullOrEmptyOrSpace(messageJsonObject.get(tTypeKey))) continue;
            tMap.put(tKey.replace("om_region_id", "eoc_region_id"), tSubObj.get("eoc_region_id").getAsString());
        }
        for (String tKey : tMap.keySet()) {
            messageJsonObject.addProperty(tKey, (String)tMap.get(tKey));
        }
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject, EocTypeEnum eocType, RequestModel requestModel) {
        String sourceTag = null;
        String targetTag = null;
        JsonElement element = null;
        element = messageJsonObject.get(eocType.getEocTag());
        if (!JsonUtil.isNullOrEmptyOrSpace(element)) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else {
            element = messageJsonObject.get(eocType.getOmTag());
            if (!JsonUtil.isNullOrEmptyOrSpace(element)) {
                sourceTag = eocType.getOmTag();
                targetTag = eocType.getEocTag();
            }
        }
        if (sourceTag != null) {
            JsonObject tSubObj;
            String sourceValue = element.getAsString();
            if (requestModel != null && EocTypeEnum.COMPANY.getEocTag().equals(sourceTag)) {
                requestModel.addDispatchCompany(sourceValue);
            }
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(sourceTag.replace("ex_", ""), sourceValue);
            if (eocType.equals((Object)EocTypeEnum.REGION) && messageJsonObject.get(REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, messageJsonObject.get(REGION_TYPE).getAsString());
            }
            if (eocType.equals((Object)EocTypeEnum.EX_REGION) && messageJsonObject.get(EX_REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, messageJsonObject.get(EX_REGION_TYPE).getAsString());
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null) {
                messageJsonObject.addProperty(targetTag, tSubObj.get(targetTag.replace("ex_", "")).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transform(messageJsonObject, tSubObj, EocTypeEnum.SITE, null);
                }
                if (eocType.equals((Object)EocTypeEnum.EX_COMPANY)) {
                    EocOmTransformUtil.transform(messageJsonObject, tSubObj, EocTypeEnum.EX_SITE, null);
                }
            }
        }
    }

    private static void transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, JsonObject mappingJsonObject, EocTypeEnum eocType) {
        String sourceTag = null;
        String targetTag = null;
        if (!StringUtil.isEmptyOrSpace(sourceMap.get(eocType.getEocTag()))) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else if (!StringUtil.isEmptyOrSpace(sourceMap.get(eocType.getOmTag()))) {
            sourceTag = eocType.getOmTag();
            targetTag = eocType.getEocTag();
        }
        if (sourceTag != null) {
            JsonObject tSubObj;
            String sourceValue = sourceMap.get(sourceTag);
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(sourceTag, sourceValue);
            if (eocType.equals((Object)EocTypeEnum.REGION) && sourceMap.get(REGION_TYPE) != null) {
                targetMap.put(REGION_TYPE, sourceMap.get(REGION_TYPE));
                tConditionMap.put(REGION_TYPE, sourceMap.get(REGION_TYPE));
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null) {
                targetMap.put(targetTag, tSubObj.get(targetTag).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tSubObj, EocTypeEnum.SITE);
                }
            }
        }
    }

    private static void transformEocOmMapObject(Map<String, Object> targetMap, Map<String, Object> sourceMap, JsonObject mappingJsonObject, EocTypeEnum eocType) {
        String sourceTag = null;
        String targetTag = null;
        if (!StringUtil.isEmptyOrSpace(sourceMap.get(eocType.getEocTag()))) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else if (!StringUtil.isEmptyOrSpace(sourceMap.get(eocType.getOmTag()))) {
            sourceTag = eocType.getOmTag();
            targetTag = eocType.getEocTag();
        }
        if (sourceTag != null) {
            JsonObject tSubObj;
            String sourceValue = (String)sourceMap.get(sourceTag);
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(sourceTag, sourceValue);
            if (eocType.equals((Object)EocTypeEnum.REGION) && sourceMap.get(REGION_TYPE) != null) {
                targetMap.put(REGION_TYPE, sourceMap.get(REGION_TYPE));
                tConditionMap.put(REGION_TYPE, (String)sourceMap.get(REGION_TYPE));
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null) {
                targetMap.put(targetTag, tSubObj.get(targetTag).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transformEocOmMapObject(targetMap, sourceMap, tSubObj, EocTypeEnum.SITE);
                }
            }
        }
    }

    private static void setExecutionProduct(MessageModel messageModel) throws Exception {
        JsonObject tActionExecutionInfoJsonObject;
        String tStatus;
        RequestModel requestModel = messageModel.getRequestModel();
        String dapChain = requestModel.getHeader(KEY_HEADER_CHAIN_INFO);
        String securityToken = requestModel.getHeader(KEY_HEADER_SECURITY_TOKEN);
        if (messageModel.getActionExecutionInfoJsonObject() == null) {
            String token = requestModel.getHeader(KEY_HEADER_TOKEN);
            if (StringUtil.isEmptyOrSpace(token)) {
                token = requestModel.getHeader(KEY_HEADER_DIGI_TOKEN);
            }
            messageModel.setActionExecutionInfoJsonObject(EocOmTransformUtil.getActionExecutionInfo(requestModel.getTenantId(), requestModel.getServiceName(), token, dapChain, securityToken));
        }
        String string = tStatus = (tActionExecutionInfoJsonObject = messageModel.getActionExecutionInfoJsonObject()).get("status") != null ? tActionExecutionInfoJsonObject.get("status").getAsString() : null;
        if (!"200".equals(tStatus)) {
            String tErrorMessage = tActionExecutionInfoJsonObject.get("errorMessage") != null ? tActionExecutionInfoJsonObject.get("errorMessage").getAsString() : null;
            throw new TenantInfoNotFoundException(String.format("An error occurred while querying service product. KnowledgeMap host:[%s], tenantId:[%s], api:[%s], sourceReqid:[%s], token:[%s], response status:[%s], error message:[%s]", URLConstant.TM_BASE_URL, requestModel.getTenantId(), requestModel.getServiceName(), requestModel.getDebugInfo("sourceReqid"), requestModel.getHeader(KEY_HEADER_TOKEN), tStatus, tErrorMessage));
        }
        String tProd = null;
        try {
            tProd = tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("productName").getAsString();
        }
        catch (Exception e) {
            throw new TenantInfoNotFoundException(String.format("Service product is empty or space. KnowledgeMap host:[%s], tenantId:[%s], api:[%s], KM response:[%s]]", URLConstant.TM_BASE_URL, requestModel.getTenantId(), requestModel.getServiceName(), tActionExecutionInfoJsonObject.toString()));
        }
        if (StringUtil.isEmptyOrSpace(tProd)) {
            throw new TenantInfoNotFoundException(String.format("Service product is empty or space. KnowledgeMap host:[%s], tenantId:[%s], api:[%s]", URLConstant.TM_BASE_URL, requestModel.getTenantId(), requestModel.getServiceName()));
        }
        requestModel.setServiceProd(tProd);
        if (requestModel.getServiceProdUid() == null && tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("productUid") != null && !tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("productUid").isJsonNull()) {
            requestModel.setServiceProdUid(tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("productUid").getAsString());
        }
    }

    private static void setAppVersionInfo(MessageModel messageModel) {
        RequestModel requestModel = messageModel.getRequestModel();
        String dapChain = requestModel.getHeader(KEY_HEADER_CHAIN_INFO);
        String securityToken = requestModel.getHeader(KEY_HEADER_SECURITY_TOKEN);
        if (messageModel.getActionExecutionInfoJsonObject() == null) {
            String token = requestModel.getHeader(KEY_HEADER_TOKEN);
            if (StringUtil.isEmptyOrSpace(token)) {
                token = requestModel.getHeader(KEY_HEADER_DIGI_TOKEN);
            }
            try {
                messageModel.setActionExecutionInfoJsonObject(EocOmTransformUtil.getActionExecutionInfo(requestModel.getTenantId(), requestModel.getServiceName(), token, dapChain, securityToken));
            }
            catch (Exception e) {
                log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]get Action Execution Info error:{}"), (Throwable)e);
                return;
            }
        }
        JsonObject tActionExecutionInfoJsonObject = messageModel.getActionExecutionInfoJsonObject();
        String AppId = null;
        String AppVer = null;
        if (!JsonUtil.isNull(tActionExecutionInfoJsonObject.get("response")) && tActionExecutionInfoJsonObject.get("response").isJsonObject()) {
            AppId = tActionExecutionInfoJsonObject.get("response").getAsJsonObject().has("appCode") && !tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("appCode").isJsonNull() ? tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("appCode").getAsString() : null;
            String string = AppVer = tActionExecutionInfoJsonObject.get("response").getAsJsonObject().has("appVersion") && !tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("appVersion").isJsonNull() ? tActionExecutionInfoJsonObject.get("response").getAsJsonObject().get("appVersion").getAsString() : null;
        }
        if (!StringUtil.isEmptyOrSpace(AppId)) {
            requestModel.setAppVer(AppId, AppVer);
        }
    }

    private static JsonObject getActionExecutionInfo(String tenantId, String apiName, String userToken, String dapChain, String securityToken) throws Exception {
        String tURL = URLConstant.TM_BASE_URL + PATH_TM_QUERY_EXECUTION_INFO_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("actionId", "esp_" + apiName.trim());
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader(KEY_HEADER_TOKEN, userToken);
        tHttpPost.addHeader(KEY_HEADER_ROUTER_KEY, tenantId);
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        if (dapChain != null) {
            tHttpPost.addHeader(KEY_HEADER_CHAIN_INFO, dapChain);
        }
        if (securityToken != null) {
            tHttpPost.addHeader(KEY_HEADER_SECURITY_TOKEN, securityToken);
        }
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        return tReturnJsonObject;
    }

    public static JsonObject getMappingJsonObject(String tenantId, String product, String id, String uid, String dapChain, String securityToken) throws Exception {
        String tURL = URLConstant.MDC_BASE_URL + PATH_DAP_MDC_TENANT_PRODUCT_OPERATION_LIST_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("tenant_id", tenantId.trim());
        tJsonObject.addProperty("prod_name", product.trim());
        if (id != null) {
            tJsonObject.addProperty("id", id);
        }
        if (uid != null) {
            tJsonObject.addProperty(UID, uid);
        }
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader(KEY_HEADER_ROUTER_KEY, tenantId);
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        if (dapChain != null) {
            tHttpPost.addHeader(KEY_HEADER_CHAIN_INFO, dapChain);
        }
        if (securityToken != null) {
            tHttpPost.addHeader(KEY_HEADER_SECURITY_TOKEN, securityToken);
        }
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        return tReturnJsonObject;
    }

    public static JsonObject getMappingJsonObjectV2(String tenantId, String product) throws Exception {
        String tURL = URLConstant.MDC_BASE_URL + PATH_DAP_MDC_TENANT_PRODUCT_OPERATION_LIST_V2_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("tenant_id", tenantId.trim());
        tJsonObject.addProperty("prod_name", product.trim());
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader(KEY_HEADER_ROUTER_KEY, tenantId);
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
        return JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
    }

    private static boolean checkTransform(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        Pattern tRegexP = Pattern.compile(REGULAR);
        Matcher tMatch = tRegexP.matcher(message);
        return tMatch.find();
    }

    private static boolean checkTransformV2(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        Pattern tRegexP = Pattern.compile(REGULAR_V2);
        Matcher tMatch = tRegexP.matcher(message);
        return tMatch.find();
    }

    private static boolean hasTransformInfo(JsonObject mappingJsonObject) {
        JsonElement company = mappingJsonObject.get(EocTypeEnum.COMPANY.getLevelTag());
        JsonElement region = mappingJsonObject.get(EocTypeEnum.REGION.getLevelTag());
        return !JsonUtil.isNull(company) && company.getAsJsonArray().size() != 0 || !JsonUtil.isNull(region) && region.getAsJsonArray().size() != 0;
    }

    private static boolean hasTransformInfoV2(JsonObject mappingJsonObject) {
        JsonArray asJsonArray = mappingJsonObject.getAsJsonArray("org_type_mapping");
        return !JsonUtil.isNull((JsonElement)asJsonArray) && asJsonArray.getAsJsonArray().size() != 0;
    }

    private static JsonObject searchSubEocJsonObject(JsonObject eocJsonObject, EocTypeEnum eocType, Map<String, String> conditionMap) {
        JsonArray eocJsonArray;
        if (eocJsonObject.get(eocType.getLevelTag()) != null && (eocJsonArray = eocJsonObject.get(eocType.getLevelTag()).getAsJsonArray()).size() > 0) {
            Set<String> keySet = conditionMap.keySet();
            for (int i = 0; i < eocJsonArray.size(); ++i) {
                boolean result = true;
                JsonObject tObj = eocJsonArray.get(i).getAsJsonObject();
                for (String key : keySet) {
                    if (conditionMap.get(key).equals(tObj.get(key).getAsString())) continue;
                    result = false;
                    break;
                }
                if (!result) continue;
                return tObj;
            }
        }
        return null;
    }

    private static void setDispatchInfo(MessageModel messageModel, JsonObject baseInfo) {
        Iterator<String> tIt;
        JsonArray dpJsonArray;
        RequestModel requestModel = messageModel.getRequestModel();
        if (requestModel.getEocMap() != null && !StringUtil.isEmptyOrSpace(requestModel.getEocMap().get("eoc_company_id"))) {
            return;
        }
        if (requestModel.getHeaderMap().containsKey("digi-eoc-dispatch")) {
            JsonArray list = new JsonParser().parse(requestModel.getHeader("digi-eoc-dispatch")).getAsJsonObject().get("eoc_company_id").getAsJsonArray();
            for (JsonElement company : list) {
                requestModel.addDispatchCompany(company.getAsString());
            }
            requestModel.getHeaderMap().remove("digi-eoc-dispatch");
        }
        if (JsonUtil.isNull((JsonElement)(dpJsonArray = JsonUtil.getArrayPropFromJson(baseInfo, BASE_INFO_KEY_DISPATCH, null))) || dpJsonArray.size() == 0) {
            return;
        }
        ArrayList<EocDispatchInfoModel> dpList = new ArrayList<EocDispatchInfoModel>();
        if (requestModel.getDispatchCompanys() != null && !requestModel.getDispatchCompanys().isEmpty()) {
            tIt = requestModel.getDispatchCompanys().iterator();
            while (tIt.hasNext()) {
                EocDispatchInfoModel dpModel = new EocDispatchInfoModel();
                dpModel.setEocCompanyId(tIt.next());
                dpList.add(dpModel);
            }
        } else {
            for (JsonElement dpJsonElement : dpJsonArray) {
                JsonObject doOperation;
                if (JsonUtil.isNull(dpJsonElement.getAsJsonObject().get("operation_manager")) || !(doOperation = dpJsonElement.getAsJsonObject().get("operation_manager").getAsJsonObject()).has("eoc_company_id")) continue;
                EocDispatchInfoModel dpModel = new EocDispatchInfoModel();
                dpModel.setEocCompanyId(doOperation.get("eoc_company_id").getAsString());
                dpList.add(dpModel);
            }
        }
        for (EocDispatchInfoModel dpModel : dpList) {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("eoc_company_id", dpModel.getEocCompanyId());
            JsonObject tSubObj = EocOmTransformUtil.searchSubEocJsonObject(messageModel.getEocMappingJsonObject(), EocTypeEnum.COMPANY, condition);
            if (tSubObj == null || !tSubObj.has(DATAKEY)) continue;
            dpModel.addDatakey(tSubObj.get(DATAKEY).getAsString(), tSubObj.get("om_company_id").getAsString());
            dpModel.setOmCompanyId(tSubObj.get("om_company_id").getAsString());
        }
        if (dpList.size() == 1) {
            requestModel.addEocId("eoc_company_id", ((EocDispatchInfoModel)dpList.get(0)).getEocCompanyId());
            requestModel.addOmId("om_company_id", ((EocDispatchInfoModel)dpList.get(0)).getOmCompanyId());
            tIt = ((EocDispatchInfoModel)dpList.get(0)).getDatakey().keySet().iterator();
            if (tIt.hasNext()) {
                String key = tIt.next();
                requestModel.addDatakey(key, ((EocDispatchInfoModel)dpList.get(0)).getDatakey(key));
            }
            return;
        }
        messageModel.getRequestModel().setEocDispatchInfoModelList(dpList);
    }

    private static void setDispatchInfoV2(MessageModel messageModel, JsonObject baseInfo) {
        Iterator<String> tIt;
        JsonArray dpJsonArray;
        JsonArray orgTypeMapping = messageModel.getEocMappingJsonObject().getAsJsonArray("org_type_mapping");
        HashMap companyMappingMap = new HashMap();
        orgTypeMapping.forEach(jsonElement -> {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if ("company_id".equals(jsonObject.get("type").getAsString())) {
                companyMappingMap.put(jsonObject.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString(), jsonObject);
            }
        });
        RequestModel requestModel = messageModel.getRequestModel();
        if (requestModel.getEocMap() != null) {
            String eocMappingId = null;
            Map value = (Map)requestModel.getEocMap().get("operation_unit_v2");
            if (value != null && value.get("eoc_mapping_id") != null) {
                eocMappingId = (String)value.get("eoc_mapping_id");
            }
            Object opsUnitNo = requestModel.getEocMap().get("ops_unit_no");
            if (StringUtils.isBlank(eocMappingId) && opsUnitNo != null) {
                eocMappingId = (String)requestModel.getEocMap().get("ops_unit_no");
            }
            if (eocMappingId == null) {
                return;
            }
            if (companyMappingMap.get(eocMappingId) != null) {
                return;
            }
        }
        if (requestModel.getHeaderMap().containsKey("digi-eoc-dispatch")) {
            JsonArray list = new JsonParser().parse(requestModel.getHeader("digi-eoc-dispatch")).getAsJsonObject().get("eoc_company_id").getAsJsonArray();
            for (JsonElement company : list) {
                requestModel.addDispatchCompany(company.getAsString());
            }
            requestModel.getHeaderMap().remove("digi-eoc-dispatch");
        }
        if (JsonUtil.isNull((JsonElement)(dpJsonArray = JsonUtil.getArrayPropFromJson(baseInfo, BASE_INFO_KEY_DISPATCH, null))) || dpJsonArray.size() == 0) {
            return;
        }
        ArrayList<EocDispatchInfoModel> dpList = new ArrayList<EocDispatchInfoModel>();
        if (requestModel.getDispatchCompanys() != null && !requestModel.getDispatchCompanys().isEmpty()) {
            tIt = requestModel.getDispatchCompanys().iterator();
            while (tIt.hasNext()) {
                EocDispatchInfoModel dpModel = new EocDispatchInfoModel();
                dpModel.setEocCompanyId(tIt.next());
                dpList.add(dpModel);
            }
        } else {
            for (JsonElement dpJsonElement : dpJsonArray) {
                JsonObject doOperation;
                if (JsonUtil.isNull(dpJsonElement.getAsJsonObject().get("operation_manager")) || !"company_id".equals((doOperation = dpJsonElement.getAsJsonObject().get("operation_manager").getAsJsonObject()).get("type").getAsString())) continue;
                EocDispatchInfoModel dpModel = new EocDispatchInfoModel();
                dpModel.setEocCompanyId(doOperation.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString());
                dpList.add(dpModel);
            }
        }
        for (EocDispatchInfoModel dpModel : dpList) {
            JsonObject jsonObject = (JsonObject)companyMappingMap.get(dpModel.getEocCompanyId());
            if (jsonObject == null || !jsonObject.has(DATAKEY)) continue;
            dpModel.addDatakey(jsonObject.get(DATAKEY).getAsString(), jsonObject.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
            dpModel.setOmCompanyId(jsonObject.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
        }
        if (dpList.size() == 1) {
            requestModel.addEocId("eoc_company_id", ((EocDispatchInfoModel)dpList.get(0)).getEocCompanyId());
            requestModel.addOmId("om_company_id", ((EocDispatchInfoModel)dpList.get(0)).getOmCompanyId());
            tIt = ((EocDispatchInfoModel)dpList.get(0)).getDatakey().keySet().iterator();
            if (tIt.hasNext()) {
                String key = tIt.next();
                requestModel.addDatakey(key, ((EocDispatchInfoModel)dpList.get(0)).getDatakey(key));
            }
            return;
        }
        messageModel.getRequestModel().setEocDispatchInfoModelList(dpList);
    }

    private static JsonObject getDispatchInfo(String tenantId, String prodName, String apiName, String userToken, String dapChain, String securityToken) throws Exception {
        String tURL = URLConstant.MDC_BASE_URL + PATH_MDC_TENANT_PRODUCT_API_DISPATCH_INFO_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("tenant_id", tenantId);
        tJsonObject.addProperty("prod_name", prodName);
        tJsonObject.addProperty("api_name", apiName);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader(KEY_HEADER_TOKEN, userToken);
        tHttpPost.addHeader(KEY_HEADER_ROUTER_KEY, tenantId);
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        if (dapChain != null) {
            tHttpPost.addHeader(KEY_HEADER_CHAIN_INFO, dapChain);
        }
        if (securityToken != null) {
            tHttpPost.addHeader(KEY_HEADER_SECURITY_TOKEN, securityToken);
        }
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        return tReturnJsonObject;
    }

    private static JsonObject getBaseInfo(MessageModel messageModel, boolean needDispatch, boolean needIdempotency) throws Exception {
        RequestModel requestModel = messageModel.getRequestModel();
        String dapChain = requestModel.getHeader(KEY_HEADER_CHAIN_INFO);
        String securityToken = requestModel.getHeader(KEY_HEADER_SECURITY_TOKEN);
        String token = requestModel.getHeader(KEY_HEADER_TOKEN);
        if (StringUtil.isEmptyOrSpace(token)) {
            token = requestModel.getHeader(KEY_HEADER_DIGI_TOKEN);
        }
        String tURL = URLConstant.MDC_BASE_URL + PATH_MDC_SERVICE_BASE_INFO_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("apiName", requestModel.getServiceName());
        tJsonObject.addProperty("tenantId", requestModel.getTenantId());
        if (requestModel.getServiceProdUid() != null) {
            tJsonObject.addProperty("serviceProdUid", requestModel.getServiceProdUid());
        }
        if (requestModel.getServiceProd() != null) {
            tJsonObject.addProperty("serviceProd", requestModel.getServiceProd());
        }
        tJsonObject.addProperty("needDispatch", Boolean.valueOf(needDispatch));
        tJsonObject.addProperty("needIdempotency", Boolean.valueOf(needIdempotency));
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader(KEY_HEADER_TOKEN, token);
        tHttpPost.addHeader(KEY_HEADER_ROUTER_KEY, requestModel.getTenantId());
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tHttpPost.addHeader(KEY_HEADER_APP_TOKEN, AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tHttpPost.addHeader(KEY_HEADER_APP_SECRET, AppConstant.APP_SECRET);
        }
        if (dapChain != null) {
            tHttpPost.addHeader(KEY_HEADER_CHAIN_INFO, dapChain);
        }
        if (securityToken != null) {
            tHttpPost.addHeader(KEY_HEADER_SECURITY_TOKEN, securityToken);
        }
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpWithDapRetry((HttpUriRequest)tHttpPost, true);
        JsonObject rs = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        return JsonUtil.getJsonObjectPropFromJson(rs, "data", null);
    }

    private static boolean isNeedDispatch(MessageModel messageModel) {
        RequestModel requestModel = messageModel.getRequestModel();
        return requestModel.getEocMap() == null || StringUtil.isEmptyOrSpace(requestModel.getEocMap().get("eoc_company_id"));
    }

    private static void cacheMDCProdName(MessageModel messageModel) {
        if (!DAPUtil.isCacheAnonymousMethod()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)messageModel.getRequestModel().getServiceName()) || StringUtils.isBlank((CharSequence)messageModel.getRequestModel().getServiceProd())) {
            return;
        }
        Map<String, Object> httpHeaders = messageModel.getRequestModel().getHttpHeaders();
        String espRequestTenantId = null;
        try {
            espRequestTenantId = ESPLoadBalanceUtil.getESPRequestTenantId(httpHeaders);
        }
        catch (Exception e) {
            return;
        }
        ESPServerNameCacheUtil.putAnonymousCatche((String)messageModel.getRequestModel().getServiceName(), (String)espRequestTenantId, (String)messageModel.getRequestModel().getServiceProd());
    }

    private static String richMDCProdNameFromCache(MessageModel messageModel) {
        if (!DAPUtil.isCacheAnonymousMethod()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)messageModel.getRequestModel().getServiceName()) || StringUtils.isNotBlank((CharSequence)messageModel.getRequestModel().getServiceProd())) {
            return null;
        }
        Map<String, Object> httpHeaders = messageModel.getRequestModel().getHttpHeaders();
        String espRequestTenantId = null;
        try {
            espRequestTenantId = ESPLoadBalanceUtil.getESPRequestTenantId(httpHeaders);
        }
        catch (Exception e) {
            return null;
        }
        String cachedServiceProd = ESPServerNameCacheUtil.getAnonymousCatche((String)messageModel.getRequestModel().getServiceName(), (String)espRequestTenantId);
        messageModel.getRequestModel().setServiceProd(cachedServiceProd);
        return cachedServiceProd;
    }

    private static String transformV2(String message, JsonObject mappingJsonObject, RequestModel requestModel) {
        JsonParser tJsonParser = new JsonParser();
        JsonElement tMessageElement = tJsonParser.parse(message);
        EocOmTransformUtil.processTransformV2Recursive(tMessageElement, mappingJsonObject, requestModel);
        return tMessageElement.toString();
    }

    private static void processTransformV2Recursive(JsonElement element, JsonObject mappingJsonObject, RequestModel requestModel) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("ops_unit_no") && !obj.get("ops_unit_no").isJsonNull() && obj.get("ops_unit_no").isJsonPrimitive() && !obj.get("ops_unit_no").getAsString().isEmpty()) {
                String opsUnitNo = obj.get("ops_unit_no").getAsString();
                HashMap<String, Object> targetMap = new HashMap<String, Object>();
                HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                sourceMap.put("ops_unit_no", opsUnitNo);
                EocOmTransformUtil.eocTransformOmByBodyV2(targetMap, sourceMap, mappingJsonObject, requestModel);
                targetMap.forEach((k, v) -> {
                    if (!obj.has(k)) {
                        obj.addProperty(k, v.toString());
                    }
                });
            } else {
                String opsUnitNo = null;
                Map<String, String> inputMap = EocOmTransformUtil.buildInputMap(obj);
                if (!inputMap.isEmpty()) {
                    Map<String, Map<String, String>> eocIndex = EocOmTransformUtil.buildEocIndex(mappingJsonObject);
                    List<String> candidates = EocOmTransformUtil.findExactMatches(inputMap, eocIndex);
                    if (!candidates.isEmpty() && StringUtils.isNotBlank((CharSequence)(opsUnitNo = EocOmTransformUtil.handleMultipleMatches(candidates, "exact_match")))) {
                        obj.addProperty("ops_unit_no", opsUnitNo);
                    }
                    if (StringUtils.isBlank(opsUnitNo) && inputMap.containsKey("site_id") && inputMap.size() == 1 && !(candidates = EocOmTransformUtil.findSiteIdMatches(inputMap.get("site_id"), eocIndex)).isEmpty() && StringUtils.isNotBlank((CharSequence)(opsUnitNo = EocOmTransformUtil.handleMultipleMatches(candidates, "site_id_match")))) {
                        obj.addProperty("ops_unit_no", opsUnitNo);
                    }
                }
            }
            obj.entrySet().forEach(entry -> EocOmTransformUtil.processTransformV2Recursive((JsonElement)entry.getValue(), mappingJsonObject, requestModel));
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            array.forEach(item -> EocOmTransformUtil.processTransformV2Recursive(item, mappingJsonObject, requestModel));
        }
    }

    private static void eocTransformOmByBodyV2(Map<String, Object> targetMap, Map<String, Object> sourceMap, JsonObject mappingJsonObject, RequestModel requestModel) {
        String eocMappingId = null;
        Object opsUnitNo = sourceMap.get("ops_unit_no");
        if (opsUnitNo != null) {
            eocMappingId = (String)sourceMap.get("ops_unit_no");
        }
        if (eocMappingId == null) {
            return;
        }
        JsonArray orgTypeMapping = mappingJsonObject.getAsJsonArray("org_type_mapping");
        String finalEocMappingId = eocMappingId;
        orgTypeMapping.forEach(item -> {
            JsonObject itemObj = (JsonObject)item;
            if (itemObj.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString().equals(finalEocMappingId)) {
                if (itemObj.get("type").getAsString().equals("company_id")) {
                    targetMap.put(EocTypeEnum.COMPANY.getOmTag(), itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
                    if (requestModel != null) {
                        requestModel.addDispatchCompany(finalEocMappingId);
                    }
                } else if (itemObj.get("type").getAsString().equals("site_id")) {
                    targetMap.put(EocTypeEnum.SITE.getOmTag(), itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
                } else if (itemObj.get("type").getAsString().equals("region_id")) {
                    targetMap.put(EocTypeEnum.REGION.getOmTag(), itemObj.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString());
                }
            }
        });
    }

    private static Map<String, String> buildInputMap(JsonObject obj) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        EocOmTransformUtil.putIfValid(map, "company_id", obj, EocTypeEnum.COMPANY.getOmTag());
        EocOmTransformUtil.putIfValid(map, "region_id", obj, EocTypeEnum.REGION.getOmTag());
        EocOmTransformUtil.putIfValid(map, "site_id", obj, EocTypeEnum.SITE.getOmTag());
        return map;
    }

    private static void putIfValid(Map<String, String> map, String typeKey, JsonObject obj, String fieldName) {
        String value;
        if (obj.has(fieldName) && StringUtils.isNotBlank((CharSequence)(value = obj.get(fieldName).getAsString()))) {
            map.put(typeKey, value);
        }
    }

    private static Map<String, Map<String, String>> buildEocIndex(JsonObject mapping) {
        LinkedHashMap<String, Map<String, String>> index = new LinkedHashMap<String, Map<String, String>>();
        JsonArray mappings = mapping.getAsJsonArray("org_type_mapping");
        for (JsonElement el : mappings) {
            JsonObject m = el.getAsJsonObject();
            String eocId = m.get(EocTypeEnum.MAPPING_V2.getEocTag()).getAsString();
            String type = m.get("type").getAsString();
            String omId = m.get(EocTypeEnum.MAPPING_V2.getOmTag()).getAsString();
            index.computeIfAbsent(eocId, k -> new HashMap()).put(type, omId);
        }
        return index;
    }

    private static List<String> findExactMatches(Map<String, String> inputMap, Map<String, Map<String, String>> eocIndex) {
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : eocIndex.entrySet()) {
            if (!EocOmTransformUtil.isExactMatch(inputMap, entry.getValue())) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }

    private static boolean isExactMatch(Map<String, String> inputMap, Map<String, String> typeMap) {
        if (typeMap.size() != inputMap.size()) {
            return false;
        }
        return inputMap.entrySet().stream().allMatch(e -> typeMap.containsKey(e.getKey()) && ((String)typeMap.get(e.getKey())).equals(e.getValue()));
    }

    private static String handleMultipleMatches(List<String> candidates, String matchType) {
        if (candidates.size() > 1) {
            log.error((Object)("Multiple " + matchType + " candidates found (" + candidates.size() + "), returning first: " + candidates));
            return null;
        }
        return candidates.get(0);
    }

    private static void processJson(JsonElement element, String targetKey, String newKey, String newValue) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            if (obj.has(targetKey)) {
                obj.addProperty(newKey, newValue);
            }
            obj.entrySet().forEach(entry -> EocOmTransformUtil.processJson((JsonElement)entry.getValue(), targetKey, newKey, newValue));
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            array.forEach(item -> EocOmTransformUtil.processJson(item, targetKey, newKey, newValue));
        }
    }

    private static List<String> findSiteIdMatches(String siteIdValue, Map<String, Map<String, String>> eocIndex) {
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : eocIndex.entrySet()) {
            Map<String, String> typeMap = entry.getValue();
            if (!typeMap.containsKey("site_id") || !typeMap.get("site_id").equals(siteIdValue)) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }
}

