/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.model.ApiInvokeInfoModel;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.MqPublishParam;
import com.digiwin.athena.esp.sdk.mq.RabbitMqManager;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MQUtil {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() << 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static final String MQ_EXCHANGE_NAME = "DC_API_EXCHANGE";
    private static final String MQ_EXCHANGE_TYPE = "direct";
    private static final String MQ_QUEUE_NAME = "DC_API_QUEUE";
    private static final String MQ_ROUTING_KEY = "DC_API_ROUTER_KEY";
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";

    public static boolean sendApiInvokeInfo(MessageModel messageModel) {
        Runtime.getRuntime().availableProcessors();
        ApiInvokeInfoModel apiInvokeInfo = new ApiInvokeInfoModel();
        apiInvokeInfo.setTenantId(messageModel.getRequestModel().getTenantId());
        apiInvokeInfo.setServiceName(messageModel.getRequestModel().getServiceName());
        apiInvokeInfo.setEocId(StringUtil.isEmptyOrSpace(messageModel.getRequestModel().getEocMap()) ? new HashMap() : messageModel.getRequestModel().getEocMapStr());
        apiInvokeInfo.addbodyJsonString(REQUEST, StringUtil.isEmptyOrSpace(messageModel.getRequestModel().getBodyJsonString()) ? "" : JsonUtil.fromJsonMap(messageModel.getRequestModel().getBodyJsonString()));
        apiInvokeInfo.addbodyJsonString(RESPONSE, StringUtil.isEmptyOrSpace(messageModel.getResponseModel().getBodyJsonString()) ? "" : JsonUtil.fromJsonMap(messageModel.getResponseModel().getBodyJsonString()));
        try {
            final MqPublishParam publishParam = new MqPublishParam();
            publishParam.setExchangeName(MQ_EXCHANGE_NAME);
            publishParam.setExchangeType(MQ_EXCHANGE_TYPE);
            publishParam.setQueueName(MQ_QUEUE_NAME);
            publishParam.setRoutingKey(MQ_ROUTING_KEY);
            publishParam.setMessage(JsonUtil.toString(apiInvokeInfo));
            final RabbitMqManager mqManager = RabbitMqManager.getRabbitMQManager();
            EXECUTOR_SERVICE.execute(new Runnable(){

                @Override
                public void run() {
                    mqManager.publishMessage(publishParam);
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

