/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.AbstractInvoker;
import com.digiwin.athena.esp.sdk.constants.DAPConstant;
import com.digiwin.athena.esp.sdk.dap.log.DapLogUtils;
import com.digiwin.athena.esp.sdk.dap.log.LogItemType;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapLogDto;
import com.digiwin.athena.esp.sdk.dap.log.service.DapLogService;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class DapLocalInvoker
extends AbstractInvoker {
    private static Log log = LogFactory.getLog(DapLocalInvoker.class);
    DapLogService dapLogService = new DapLogService();

    @Override
    protected String getTargetUrl(MessageModel messageModel) {
        return DAPConstant.LOCALROUTEPROCESS.getHost(messageModel.getRequestModel().getServiceProd(), messageModel.getRequestModel().getHeader("routerKey"));
    }

    @Override
    protected Map<String, Object> getRequestHeaders(RequestModel requestModel) throws Exception {
        String reqid = UUID.randomUUID().toString();
        requestModel.addHeader("digi-reqid", reqid);
        if (requestModel.getInvokeType().equals((Object)InvokeTypeEnum.FASYNC)) {
            requestModel.addHeader("digi-callback-local-url", DAPConstant.LOCAL_CALLBACK_REQUET_URL);
            if (StringUtils.isBlank((CharSequence)requestModel.getHeader("digi-callback-parent-reqid"))) {
                requestModel.addHeader("digi-callback-parent-reqid", reqid);
            }
        }
        Map<String, Object> headers = requestModel.getHttpHeaders();
        headers.remove("digi-key");
        return headers;
    }

    @Override
    protected Map<String, Object> getResponseHeaders(HttpResponse httpResponse, RequestModel requestModel) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("digi-reqid", requestModel.getHeader("digi-reqid"));
        headers.put("routerKey", requestModel.getTenantId());
        if (httpResponse == null) {
            headers.put("digi-code", "311");
            headers.put("digi-message", "RUFJIFJlc3BvbnNlOuaXoOazleiBlOacuuiHs+i/nOeoi+acjeWKoQ==");
        } else {
            for (Header header : httpResponse.getAllHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            int status = httpResponse.getStatusLine().getStatusCode();
            if (String.valueOf(status).startsWith("2")) {
                String digiMessage;
                String digiCode;
                boolean isDigiSrvCodeSuccess;
                boolean bl = isDigiSrvCodeSuccess = httpResponse.containsHeader("digi-srvcode") && "000".equals(httpResponse.getFirstHeader("digi-srvcode").getValue());
                if (requestModel.getInvokeType().equals((Object)InvokeTypeEnum.FASYNC)) {
                    if (isDigiSrvCodeSuccess) {
                        digiCode = "0E9";
                        digiMessage = "RUFJIFJlc3BvbnNlOuW5s+WPsOWbnuimhuWFqOW8guatpeivt+axguaOpeaUtueKtuaAgQ==";
                    } else {
                        digiCode = "0E6";
                        digiMessage = "5pyN5YuZ56uv5YWo55Ww5q2l6KuL5rGC5o6l5pS26Yyv6Kqk";
                    }
                } else if (isDigiSrvCodeSuccess) {
                    digiCode = "019";
                    digiMessage = "RUFJIFJlc3BvbnNlOuW5s+WPsOi/lOWbnuWQjOatpee7k+aenA==";
                } else {
                    digiCode = "016";
                    digiMessage = "5bmz5Y+w5pS25Yiw5pyN5YuZ5Zue5oeJKOWft+ihjOe1kOaenOacquespumgkOacnyk=";
                }
                headers.put("digi-code", digiCode);
                headers.put("digi-message", digiMessage);
            } else if (status == 404) {
                headers.put("digi-code", "311");
                headers.put("digi-message", "RUFJIFJlc3BvbnNlOuaXoOazleiBlOacuuiHs+i/nOeoi+acjeWKoQ==");
            } else {
                headers.put("digi-code", "322");
                headers.put("digi-message", "RUFJIFJlc3BvbnNlOui/nOeoi+acjeWKoeWPkeeUn+S+i+Wklg==");
            }
        }
        return headers;
    }

    @Override
    protected void execute(MessageModel messageModel) throws Exception {
        String tTargetUrl = this.getTargetUrl(messageModel);
        HttpPost tHttpPost = new HttpPost(tTargetUrl);
        Map<String, Object> reqHeaders = this.getRequestHeaders(messageModel.getRequestModel());
        Set<String> tKeySet = reqHeaders.keySet();
        for (String tKey : tKeySet) {
            if (reqHeaders.get(tKey) == null) continue;
            tHttpPost.setHeader(tKey, reqHeaders.get(tKey).toString());
        }
        StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        this.saveRequestLog(messageModel.getRequestModel().getTenantId(), reqHeaders, reqHeaders, messageModel.getRequestModel().getBodyJsonString());
        Long requestTime = System.currentTimeMillis();
        DapLogDto requestLog = DapLogUtils.getRequestDapLog(requestTime, messageModel, reqHeaders, tTargetUrl, "");
        this.saveDapLog(requestLog);
        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost, messageModel.getRequestModel().isIdempotency());
            Integer tHttpStatus = tHttpResponse.getStatusLine().getStatusCode();
            Map<String, Object> resHeaders = this.getResponseHeaders(tHttpResponse, messageModel.getRequestModel());
            ResponseModel tResponseModel = new ResponseModel(resHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
            messageModel.setResponseModel(tResponseModel);
            DapLogDto responseLog = DapLogUtils.getDapLog(messageModel, LogItemType.RESPONSE, tTargetUrl, messageModel.getRequestModel().getHostProd());
            this.saveDapLog(responseLog);
        }
        catch (Exception e) {
            DapLogDto responseLog = DapLogUtils.getDapLog(messageModel, LogItemType.RESPONSE, tTargetUrl, messageModel.getRequestModel().getHostProd());
            this.saveDapLog(responseLog);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    protected void saveRequestLog(String tenantId, Map<String, Object> requestHeaders, Map<String, Object> headers, String messageBody) throws ClientProtocolException, IOException {
    }

    @Override
    protected void saveResponseLog(String tenantId, Map<String, Object> requestHeaders, Integer httpStatus, Map<String, Object> headers, String messageBody) throws ClientProtocolException, IOException {
    }

    @Override
    protected void saveResponseErrorLog(String tenantId, Map<String, Object> requestHeaders, Exception ex) throws ClientProtocolException, IOException {
    }

    private void saveDapLog(DapLogDto dapLogDto) {
        log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]start save DapLog log:" + dapLogDto));
        try {
            this.dapLogService.saveLog(dapLogDto);
        }
        catch (Throwable e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]save Dap log  error log:" + dapLogDto + ", e:{}"), e);
        }
    }
}

