/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.dap.log.log4j2;

import com.digiwin.athena.esp.sdk.dap.log.DynamicDapLogLoggerInfo;
import com.digiwin.athena.esp.sdk.dap.log.ESPLogLogger;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.IfLastModified;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log4j2ESPLogger
implements ESPLogLogger {
    private static Log log = LogFactory.getLog(Log4j2ESPLogger.class);
    private Logger realLogger;
    private LoggerContext log4jLoggerContext;
    private DynamicDapLogLoggerInfo espLogConfig;

    public Log4j2ESPLogger(LoggerContext targetLoggerContext) {
        this.log4jLoggerContext = targetLoggerContext;
        this.espLogConfig = DynamicDapLogLoggerInfo.createFilePathInfo();
    }

    @Override
    public DynamicDapLogLoggerInfo getEspLogConfig() {
        return this.espLogConfig;
    }

    @Override
    public void initialize() {
        this.initLogger(this.log4jLoggerContext, false);
    }

    @Override
    public void log(String invocationLog) {
        if (this.realLogger.getLevel() != Level.INFO || this.realLogger.getAppenders().size() == 0) {
            this.fixDynamicLogger();
        }
        this.realLogger.info(invocationLog);
    }

    public void initLogger(LoggerContext targetLoggerContext, boolean forceInit) {
        try {
            this.espLogConfig = DynamicDapLogLoggerInfo.createFilePathInfo();
            if (!this.espLogConfig.isLoggerMode()) {
                return;
            }
            if (!forceInit && this.realLogger != null) {
                log.warn((Object)"Log4j2ESPLogger.realLogger is not null, you can not initialize logger twice!");
                return;
            }
            if (targetLoggerContext == null) {
                log.warn((Object)"NULL log4j context pass to constructor, will use LoggerContext.getContext(false) return Context instead.");
                this.log4jLoggerContext = LoggerContext.getContext((boolean)false);
            } else {
                log.info((Object)"DapLogService.initLogger ready to init Target LoggerContext...");
            }
            Configuration currentConfiguration = this.log4jLoggerContext.getConfiguration();
            PatternLayout espLogLayout = PatternLayout.newBuilder().withConfiguration(currentConfiguration).withPattern("%msg%n").withCharset(Charset.forName("UTF-8")).build();
            String currentJVMFolderName = String.format("platform/log/esplog/", UUID.randomUUID().toString());
            TimeBasedTriggeringPolicy timeBasedTriggeringPolicy = TimeBasedTriggeringPolicy.newBuilder().build();
            SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = SizeBasedTriggeringPolicy.createPolicy((String)this.espLogConfig.getSizeBasedTriggeringPolicySize());
            CompositeTriggeringPolicy compositeTriggeringPolicy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{timeBasedTriggeringPolicy, sizeBasedTriggeringPolicy});
            IfFileName fileNameCondition = IfFileName.createNameCondition((String)this.espLogConfig.getDeleteActionNameCondition(), null, (PathCondition[])new PathCondition[0]);
            IfLastModified lastModifiedCondition = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)this.espLogConfig.getDeleteActionLastModifiedAge()), null);
            DeleteAction deleteAction = DeleteAction.createDeleteAction((String)this.espLogConfig.getDeleteActionBasePath(), (boolean)true, (int)1, (boolean)false, null, (PathCondition[])new PathCondition[]{fileNameCondition, lastModifiedCondition}, null, (Configuration)currentConfiguration);
            DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.newBuilder().withConfig(currentConfiguration).withCustomActions(new Action[]{deleteAction}).withMax(this.espLogConfig.getRollingFileMaxValueOfCounter()).build();
            RollingFileAppender espLogRollingFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("espLogRollingFileAppender")).setConfiguration(currentConfiguration)).withFileName(this.espLogConfig.getLogFileName()).withFilePattern(this.espLogConfig.getRollingFilePattern()).withPolicy((TriggeringPolicy)compositeTriggeringPolicy).withStrategy((RolloverStrategy)rolloverStrategy).setLayout((Layout)espLogLayout)).build();
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.FATAL, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.ERROR, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.WARN, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.INFO, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL));
            espLogRollingFileAppender.addFilter((Filter)ThresholdFilter.createFilter((Level)Level.DEBUG, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY));
            espLogRollingFileAppender.start();
            ConsoleAppender espLogConsoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("espLogConsoleAppender")).setConfiguration(currentConfiguration)).setLayout((Layout)espLogLayout)).build();
            espLogConsoleAppender.start();
            currentConfiguration.addAppender((Appender)espLogConsoleAppender);
            currentConfiguration.addAppender((Appender)espLogRollingFileAppender);
            AppenderRef consoleAppenderRef = AppenderRef.createAppenderRef((String)"espLogConsoleAppender", (Level)Level.INFO, null);
            AppenderRef rollingFileAppenderRef = AppenderRef.createAppenderRef((String)"espLogConsoleAppender", (Level)Level.INFO, null);
            AppenderRef[] appenderRefs = new AppenderRef[]{consoleAppenderRef, rollingFileAppenderRef};
            LoggerConfig espLogLoggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)this.espLogConfig.getLoggerName(), (String)"true", (AppenderRef[])appenderRefs, null, (Configuration)currentConfiguration, null);
            espLogLoggerConfig.addAppender((Appender)espLogConsoleAppender, Level.INFO, null);
            espLogLoggerConfig.addAppender((Appender)espLogRollingFileAppender, Level.INFO, null);
            currentConfiguration.addLogger(this.espLogConfig.getLoggerName(), espLogLoggerConfig);
            this.log4jLoggerContext.updateLoggers();
            this.realLogger = this.log4jLoggerContext.getLogger(this.espLogConfig.getLoggerName());
        }
        catch (Exception e) {
            log.error((Object)"esp-sdk DapLogService.initLogger failed!", (Throwable)e);
        }
    }

    private synchronized void fixDynamicLogger() {
        log.warn((Object)"esp-sdk dapLogLogger status is not correct...");
        log.warn((Object)String.format("...esp-sdk dapLogLogger log level=%s", this.realLogger.getLevel()));
        log.warn((Object)String.format("...esp-sdk dapLogLogger appender size=%s", this.realLogger.getAppenders().size()));
        log.warn((Object)"...ready to fix esp-sdk dapLogLogger, forceInit to initialize again....");
        this.initLogger(this.log4jLoggerContext, true);
    }
}

