package com.digiwin.athena.km_deployer_service.base;

import com.digiwin.athena.km_deployer_service.template.ITemplate;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description
 * @Author cai chao
 * @Date 2024/7/18 16:08
 */
@Getter
@AllArgsConstructor
public enum AbilityEnum {
    /**
     * 普通收集
     */
    COLLECT("collect", ITemplate.COLLECT_ITEM_STEP_TEMPLATE),

    /**
     * 选项收集
     */
    COLLECT_OPERATION("collectOperation", ITemplate.COLLECT_ITEM_STEP_TEMPLATE),

    /**
     * 协商
     */
    CONSULT("consult", ITemplate.CONSULT_ITEM_STEP_TEMPLATE),

    /**
     * 通知
     */
    NOTIFICATION("notification", ITemplate.NOTIFACATION_ITEM_STEP_TEMPLATE),

    /**
     * 票据OCR
     */
    OCR_BILL("ocrBill", ITemplate.BILL_ITEM_STEP_TEMPLATE),

    /**
     * 名片OCR
     */
    OCR_CARD("ocrCard", ITemplate.CARD_ITEM_STEP_TEMPLATE),

    /**
     * 会议记录
     */
    MINUTES("minutes", ITemplate.MINUTES_TASK_TEMPLATE),

    /**
     * api技能
     */
    OPENAPI("openApi", ITemplate.API_TASK_TEMPLATE),

    /**
     * 行程技能
     */
    TRIP_GENERATE("tripGenerate", ITemplate.TRIP_TASK_TEMPLATE),

    /**
     * 通用表单
     */
    FORMTASK("generalform", ITemplate.FORM_TASK_TEMPLATE),

    /**
     * 日程查询
     */
    SCHEDULE_QUERY("tripsearch",ITemplate.SCHEDULE_QUERY_TEMPLATE),

    /**
     * 日程更新
     */
    SCHEDULE_UPDATE("tripupdate",ITemplate.SCHEDULE_UPDATE_TEMPLATE),

    /**
     * 日程删除
     */
    SCHEDULE_Delete("tripdelete",ITemplate.SCHEDULE_DELETE_TEMPLATE),

    /**
     * LLM大模型技能
     */
    LLM_CALL("largemodel",ITemplate.LLM_CALL_TEMPLATE),

    /**
     * 自然语言收集
     */
    TEXT_COLLECT("textCollect", ITemplate.TEXT_COLLECT_ITEM_STEP_TEMPLATE)
    ;

    private String abilityCode;

    private String templateType;

    private static Map<String, AbilityEnum> abilityCodeEnumMap = new HashMap();

    static {
        for (AbilityEnum abilityEnum : AbilityEnum.values()) {
            abilityCodeEnumMap.put(abilityEnum.getAbilityCode(), abilityEnum);
        }
    }

    public static AbilityEnum getAbilityByCode(String abilityCode) {
        return abilityCodeEnumMap.getOrDefault(abilityCode, null);
    }
}
