package com.digiwin.athena.km_deployer_service.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;

/**
 * @Author wangyan
 * @Description //异步处理线程池
 * @Date 2023/7/20 16:40
 * @Param
 * @return
 **/
@EnableAsync
@Configuration
public class AsyncPoolConfig implements AsyncConfigurer {


    @Bean("asyncExecutor")
    public Executor getAsyncExecutor() {
        // 定义线程池
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        // 设置核心线程数
        taskExecutor.setCorePoolSize(5);
        // 设置最大线程数
        taskExecutor.setMaxPoolSize(10);
        // 设置队列的大小
        taskExecutor.setQueueCapacity(100);
        // 初始化线程池
        taskExecutor.initialize();
        return taskExecutor;

    }
}
