package com.digiwin.athena.km_deployer_service.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author:
 * @Date:
 * @Version 1.0
 * @Description
 */
@Configuration
public class CaffeineConfig {

    @Bean
    public Cache<String, String> promptCaffeineCache() {
        return Caffeine.newBuilder()
                // 初始的缓存空间大小
                .initialCapacity(10)
                // 缓存的最大条数
                .maximumSize(100)
                .build();
    }

    @Bean
    public Cache<String, String> templateCaffeineCache() {
        return Caffeine.newBuilder()
                // 初始的缓存空间大小
                .initialCapacity(10)
                // 缓存的最大条数
                .maximumSize(200)
                .build();
    }

    @Bean
    public Cache<String, List<String>> corpusCaffeineCache() {
        return Caffeine.newBuilder()
                // 初始的缓存空间大小
                .initialCapacity(10)
                // 缓存的最大条数
                .maximumSize(200)
                .build();
    }

    @Bean
    public Cache<String, String> moduleTokenCache() {
        return Caffeine.newBuilder()
                // 初始的缓存空间大小
                .initialCapacity(10)
                // 缓存的最大条数
                .maximumSize(100)
                .expireAfterWrite(2, TimeUnit.HOURS)
                .build();
    }
}
