package com.digiwin.athena.km_deployer_service.config;

import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.km_deployer_service.service.DeployService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.List;

@Configuration
public class DeployConfig implements ApplicationRunner {

    @Autowired
    DeployService deployService;

    @Autowired
    MongoTemplate mongoTemplate;

    @Scheduled(cron = "0 0 1 * * ?")
    public void cleanHisTask(){
        deployService.cleanHis();
    }

    @Scheduled(cron = "0 0/2 * * * ?")
    public void cleanTimeoutTask(){
        deployService.cleanTimeoutTask();
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        long count = mongoTemplate.count(new Query(), KmTable.class);
        List<KmTable> tables = deployService.initTables();
        System.out.println("check KmTable dbCount="+count+",docCount="+tables.size());
        if(count<tables.size()){
            System.out.println("init tables...");
            mongoTemplate.dropCollection(KmTable.class);
            mongoTemplate.insertAll(tables);
        }

    }
}
