package com.digiwin.athena.km_deployer_service.config;

import com.digiwin.athena.km_deployer_service.domain.system.AthenaUser;
import com.digiwin.loadbalance.scan.candidate.DWGroupResourceHelper;
import com.digiwin.loadbalance.service.TenantIdService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

/**
 * @author tang jie cheng
 * @date 2023-08-29 10:24
 */
@Configuration
public class LoadBalanceConfig {
    @Value("${module.iam.domain}")
    private String iamUrl;
    @Value("${appToken}")
    private String appToken;

    private final String TOKEN_VERIFY_URL = "/api/iam/v2/identity/token/analyze";
    private final String IAM_USER_TOKEN = "digi-middleware-auth-user";
    private final String IAM_APP_TOKEN = "digi-middleware-auth-app";


    //配置资源文件搜索器 （非dap项目统一为 com.digiwin.loadbalance.scan.candidate.DWGroupResourceHelper ）
    @Bean
    public DWGroupResourceHelper dwGroupResourceHelper(){
        return new DWGroupResourceHelper();
    }


    //实现 com.digiwin.loadbalance.service.TenantIdService 接口定义token 解析为 租户id
    @Bean
    TenantIdService tenantIdService(){
        RestTemplate restTemplate = new RestTemplate();
        return token -> {
            if (StringUtils.isEmpty(token)) {
                return null;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(IAM_USER_TOKEN, token);
            headers.add(IAM_APP_TOKEN, appToken);
            HttpEntity httpEntity = new HttpEntity<>(headers);
            ResponseEntity<AthenaUser> result = restTemplate.postForEntity(iamUrl + TOKEN_VERIFY_URL, httpEntity, AthenaUser.class);
            AthenaUser athenaUser = result.getBody();
            if (athenaUser == null) {
                return null;
            }
            return athenaUser.getTenantId();
        };
    }
}
