package com.digiwin.athena.km_deployer_service.config;

import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.springframework.stereotype.Component;

@Component
public class MyRedissonAutoConfigurationCustomizer implements RedissonAutoConfigurationCustomizer {
    @Override
    public void customize(Config configuration) {
        if(StringUtils.isEmpty(configuration.useSingleServer().getPassword())){
            configuration.useSingleServer().setPassword(null);
            configuration.useSingleServer().setConnectionMinimumIdleSize(2);
        }
        configuration.useSingleServer().setTimeout(15*1000);
        configuration.setThreads(5);
        configuration.setNettyThreads(10);
    }
}
