package com.digiwin.athena.km_deployer_service.config.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import lombok.Data;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

import java.util.concurrent.TimeUnit;

/***
 * 娜娜助理库配置
 **/
@Data
@Configuration
@EnableMongoRepositories(basePackages = AsaMongodbConfig.BASE_PACKAGE)
@ConditionalOnProperty(prefix = "spring.data.mongo-asa", name = "database")
public class AsaMongodbConfig extends MongoConfigurationSupport {
    public static final String BASE_PACKAGE = "com.digiwin.athena.mongodb.repository";
    public static final String MONGO_TEMPLATE_REF = "asaMongoTemplate";

    @Value("${spring.data.mongodb.uri}")
    private String uri;

    @Value("${spring.data.mongo-asa.database}")
    private String databaseAsa;

    @Bean("asaMongoClient")
    public MongoClient mongoClient() {
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder()
                .applyConnectionString(new ConnectionString(uri))
                .applyToConnectionPoolSettings(builder -> builder.maxSize(30)
                        .minSize(10)
                        .maxConnectionIdleTime(10, TimeUnit.MINUTES)
                        .maxConnectionLifeTime(10, TimeUnit.MINUTES)
                        .maxWaitTime(15, TimeUnit.MINUTES))
                .build();
        return MongoClients.create(mongoClientSettings);
    }

    @Bean("asaMongoMappingContext")
    public MongoMappingContext mongoMappingContext() {
        MongoMappingContext mappingContext = new MongoMappingContext();
        return mappingContext;
    }

    @Bean("asaMongoDbFactory")
    public SimpleMongoClientDatabaseFactory mongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory(mongoClient(), getDatabaseName());
    }

    @Bean(name = AsaMongodbConfig.MONGO_TEMPLATE_REF)
    public MongoTemplate mongoTemplate(@Qualifier("asaMongoDbFactory") MongoDatabaseFactory mongoDbFactory,
                                       @Qualifier("asaMongoMappingContext") MongoMappingContext mongoMappingContext) throws Exception {
        return new MongoTemplate(mongoDbFactory(), asaMappingMongoConverter());
    }

    @Bean("asaMappingMongoConverter")
    public MappingMongoConverter asaMappingMongoConverter() throws Exception {
        DbRefResolver dbRefResolver = new DefaultDbRefResolver(mongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, mongoMappingContext());
        //不保存 _class 属性到mongo
        converter.setTypeMapper(new DefaultMongoTypeMapper(null));
        converter.setCustomConversions(customConversions());

        return converter;
    }

    @Override
    protected String getDatabaseName() {
        return databaseAsa;
    }
}
