package com.digiwin.athena.km_deployer_service.config.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;

/**
 * @Auther: lixinyuan
 * @Date: 2022/2/9 10:06
 * @Description:
 */
public class MySimpleMongoClientDbFactory extends SimpleMongoClientDatabaseFactory {

    private String mongoSuffix = "";

    public MySimpleMongoClientDbFactory(String connectionString) {
        super(connectionString);
    }

    public MySimpleMongoClientDbFactory(ConnectionString connectionString) {
        super(connectionString);
    }

    public MySimpleMongoClientDbFactory(MongoClient mongoClient, String databaseName) {
        super(mongoClient, databaseName);
    }

    public MySimpleMongoClientDbFactory(MongoClient mongoClient, String databaseName, String mongoSuffix) {
        super(mongoClient, databaseName);
        this.mongoSuffix = mongoSuffix;
    }

    @Override
    public MongoDatabase getMongoDatabase(String dbName) throws DataAccessException {
        return super.getMongoDatabase(dbName + mongoSuffix);
    }
}
