package com.digiwin.athena.km_deployer_service.config.neo4j;

import org.neo4j.driver.Driver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class SimpleNeo4jMockConfig {

    @Bean
    @Primary
    public Driver neo4jDriver() {
        // 创建一个简单的代理，所有方法调用都安全地处理
        return (Driver) java.lang.reflect.Proxy.newProxyInstance(
                Driver.class.getClassLoader(),
                new Class[]{Driver.class},
                (proxy, method, args) -> {
                    String methodName = method.getName();
                    if ("close".equals(methodName)) {
                        return null; // close方法安全处理
                    } else if ("session".equals(methodName)) {
                        // 返回另一个Mock session
                        return java.lang.reflect.Proxy.newProxyInstance(
                                method.getReturnType().getClassLoader(),
                                new Class[]{method.getReturnType()},
                                (p, m, a) -> null
                        );
                    }
                    // 其他方法返回默认值
                    if (method.getReturnType() == boolean.class) return false;
                    if (method.getReturnType() == int.class) return 0;
                    if (method.getReturnType() == long.class) return 0L;
                    if (method.getReturnType() == void.class) return null;
                    return null;
                }
        );
    }
}