package com.digiwin.athena.km_deployer_service.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployVersionParam;
import com.digiwin.athena.km_deployer_service.domain.asa.param.SwitchVersionParam;
import com.digiwin.athena.km_deployer_service.listener.AsaDeployListener;
import com.digiwin.athena.km_deployer_service.service.asaDeploy.AsaDeployService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.servlet.http.HttpServletRequest;

/**
 * 部署接口
 */
@RestController
@RequestMapping("/asaDeploy")
@Slf4j
public class AsaDeployController {
    private static Long DEFAULT_TIME_OUT = 5 * 60 * 1000L;

    @Autowired
    private AsaDeployService asaDeployService;

    @Autowired
    private AsaDeployListener deployListener;

    /**
     * 部署
     *
     * @param deployVersionParam 部署参数
     * @return SSE事件流
     */
    @PostMapping(produces = {MediaType.TEXT_EVENT_STREAM_VALUE})
    public SseEmitter deploy(@RequestBody DeployVersionParam deployVersionParam) {

        log.info("DeployController.deployVersionParam: {}", JSON.toJSONString(deployVersionParam));
        long threadId = Thread.currentThread().getId();

        SseEmitter emitter = new SseEmitter(DEFAULT_TIME_OUT);

        try {
            deployVersionParam.setThreadId(threadId);
            deployListener.addSseEmitters(threadId, emitter);
            asaDeployService.deploy(deployVersionParam);
        } catch (Exception e) {
            log.error("发版失败:", e);
        }

        return emitter;
    }


    /**
     * 切版
     *
     * @param switchVersionParam 切版参数
     * @return SSE事件流
     */
    @PostMapping(value = "/switchVersion", produces = {MediaType.TEXT_EVENT_STREAM_VALUE})
    public SseEmitter switchVersion(@RequestBody SwitchVersionParam switchVersionParam) {
        log.info("DeployController.switchVersion: {}", JSON.toJSONString(switchVersionParam));
        long threadId = Thread.currentThread().getId();

        SseEmitter emitter = new SseEmitter(DEFAULT_TIME_OUT);

        try {
            switchVersionParam.setThreadId(threadId);
            deployListener.addSseEmitters(threadId, emitter);
            asaDeployService.switchVersion(switchVersionParam);
        } catch (Exception e) {
            log.error("switchVersion绑定租户与应用成果关系失败:", e);
        }

        return emitter;
    }
}
