package com.digiwin.athena.km_deployer_service.controller;

import com.digiwin.athena.km_deployer_service.domain.asa.assistant.Assistant;
import com.digiwin.athena.km_deployer_service.domain.asa.param.AssistantParam;
import com.digiwin.athena.km_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.km_deployer_service.service.assistant.AssistantService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * 部署接口
 */
@RestController
@RequestMapping("/assistant")
@Slf4j
public class AssistantController {
    @Autowired
    private AssistantService assistantService;

    /**
     * 部署
     *
     * @return SSE事件流
     */
    @PostMapping("/queryAssistant")
    public ResultBean deploy(@RequestBody AssistantParam assistantParam) {
        Assistant assistant = assistantService.getAssistant(assistantParam.getAssistantCode(), assistantParam.getVersion());

        return ResultBean.success(assistant);
    }
}
