package com.digiwin.athena.km_deployer_service.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.deploy.*;
import com.digiwin.athena.km_deployer_service.config.AppConfig;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.DeployDataRecord;
import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.km_deployer_service.domain.MonitorHash;
import com.digiwin.athena.km_deployer_service.domain.system.ResultBean;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.EspActionIdSwitchResDto;
import com.digiwin.athena.km_deployer_service.povo.EspSwitchMsgEnum;
import com.digiwin.athena.km_deployer_service.service.AdapterService;
import com.digiwin.athena.km_deployer_service.service.DeployService;
import com.digiwin.athena.km_deployer_service.service.km.ActionService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.util.SecurityUtils;
import com.digiwin.athena.km_deployer_service.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/deploy")
@Slf4j
public class DeployController {


    @Autowired
    MongoCrudService mongoCrudService;


    @Autowired
    MongoTemplate mongoTemplate;


    @Autowired
    DeployService deployService;

    @Autowired
    AdapterService adapterService;

    @Autowired
    AppConfig appConfig;

    @Autowired
    ActionService actionService;

    @Value("${envMode}")
    private String envMode;

    @GetMapping("test01")
    public Object test01(){
        CrudReq req = new CrudReq();
        req.setDbName("datamap");
        req.setColName("api");
        req.setParams(new HashMap<>());
        req.getParams().put("key1",1);
        List list = mongoCrudService.query(req);

        return list;
    }


    @GetMapping("init_kmtables")
    public Object init_kmtables(){
        List<KmTable> tables = deployService.initTables();

        mongoTemplate.dropCollection(KmTable.class);

        mongoTemplate.insertAll(tables);

        return tables.size();
    }

    @GetMapping("buildIndex")
    public DeployResp buildIndex() throws IOException {
        DeployResp response = new DeployResp();

//        mongoTemplate.indexOps(DeployTask.class).ensureIndex(HashedIndex.hashed("deployId"));
//        mongoTemplate.indexOps(DeployDataRecord.class).ensureIndex(HashedIndex.hashed("deployId"));
//        mongoTemplate.indexOps(DeployLog.class).ensureIndex(HashedIndex.hashed("eventId"));
//        mongoTemplate.indexOps(MonitorHash.class).ensureIndex(HashedIndex.hashed("deployId"));

        mongoTemplate.indexOps(DeployTask.class).ensureIndex(new Index().named("deployId").on("deployId", Sort.Direction.ASC));
        mongoTemplate.indexOps(DeployDataRecord.class).ensureIndex(new Index().named("deployId").on("deployId", Sort.Direction.ASC));
        mongoTemplate.indexOps(MonitorHash.class).ensureIndex(new Index().named("deployId").on("deployId", Sort.Direction.ASC));
        mongoTemplate.indexOps(DeployLog.class).ensureIndex(new Index().named("eventId").on("eventId", Sort.Direction.ASC));

        return response;
    }

    @PostMapping("deployApp")
    public DeployResp deployApp(@RequestBody DeployReq request, HttpServletRequest servletRequest) throws IOException {
        String token = servletRequest.getHeader("token");
        String routerKey = servletRequest.getHeader("routerKey");
        request.setToken(token);
        request.setRouterKey(routerKey);
        DeployResp response = deployService.publishApplication(request);
        return response;
    }

    @PostMapping("switchApp")
    public DeployResp switchApp(@RequestBody DeployReq request, HttpServletRequest servletRequest){
        String token = servletRequest.getHeader("token");
        String routerKey = servletRequest.getHeader("routerKey");
        request.setToken(token);
        request.setRouterKey(routerKey);
        DeployResp response = null;
        if(StringUtils.isEmpty(request.getDeployId()) && CollectionUtil.isNotEmpty(request.getDeployIds())){
            response = deployService.switchApplications(request);
        }else{
            response =deployService.switchApplication(request);
        }
        return response;
    }

    @PostMapping("revokeApp")
    public DeployResp revokeApp(@RequestBody DeployReq request){
        DeployResp response = deployService.revokeApp(request);
        return response;
    }

    @PostMapping("redoApp")
    public DeployResp redoApp(@RequestBody DeployReq request){
        DeployResp response = deployService.redoApp(request);
        return response;
    }


    @PostMapping("deployLogs")
    public DeployResp deployLogs(@RequestBody DeployReq request){
        DeployResp response = new DeployResp();
        if(StringUtils.isEmpty(request.getEventId())){return response;}
        String eventId = request.getEventId();
        if(eventId.startsWith(DeployConstants.batchSwitchPrefix)){
            String eid2 = checkParent(eventId);
            if(null!=eid2){
                eventId = eid2;
            }
        }
        request.setEventId(eventId);
        Query query = Query.query(Criteria.where("eventId").is(eventId));
        DeployTask event = mongoTemplate.findOne(query,DeployTask.class);
        List<DeployLog> logs = deployService.deployLogs(request);
        response.setData(logs);
        response.setExt(event);
        return response;
    }

    private String checkParent(String parentEventId){
        if(org.springframework.util.StringUtils.isEmpty(parentEventId)){return null;}
        List<DeployTask> subTasks = mongoTemplate.find(Query.query(Criteria.where("parentEventId").is(parentEventId)),DeployTask.class);
        if(CollectionUtil.isEmpty(subTasks)){return null;}
        String eventId = null;
        for(DeployTask t : subTasks){
            if(DeployConstants.DeployStatus.create == t.getStatus()
                    || DeployConstants.DeployStatus.doing == t.getStatus()
                    || DeployConstants.DeployStatus.error==t.getStatus()){
                return t.getEventId();
            }
            eventId = t.getEventId();
        }

        return eventId;
    }




    @PostMapping("query")
    public DeployResp query(@RequestBody BasicQuery query){
        DeployResp response = new DeployResp();
        List<DeployTask> tasks = mongoTemplate.find(Utils.buildQuery(query),DeployTask.class);
        response.setData(tasks);
        return response;
    }

    @PostMapping("updateVersion")
    public DeployResp updateVersion(@RequestBody DeployReq request){
        DeployResp response = deployService.updateVersion(request);
        return response;
    }

    @PostMapping("startTask")
    public DeployResp startTask(@RequestBody DeployReq request){
        DeployResp response = new DeployResp();
        deployService.restartTaking(request,false);
        return response;
    }

    @PostMapping("stopTask")
    public DeployResp stopTask(@RequestBody DeployReq request){
        DeployResp response = new DeployResp();
        deployService.stopTaking(request,false);
        return response;
    }


    @PostMapping("initApplicationSourceId")
    public DeployResp initApplicationSourceId(@RequestBody DeployReq request) throws IOException {
        DeployResp response = deployService.test_initApplicationSourceId(request);
        return response;
    }

    @PostMapping("cleanApplicationSourceId")
    public DeployResp cleanApplicationSourceId(@RequestBody DeployReq request) throws IOException {
        DeployResp response = deployService.test_cleanApplicationSourceId(request);
        return response;
    }


    @GetMapping("initTenantId")
    public DeployResp initTenantId() throws IOException {
        DeployResp response = deployService.test_initTenantId();
        return response;
    }

    @PostMapping("cleanDeploy")
    public DeployResp cleanDeploy(@RequestBody DeployReq request) throws IOException {
        DeployResp response = new DeployResp();
        deployService.cleandeploy(request.getDeployId());
        return response;
    }

    @GetMapping("cleanAll")
    public DeployResp cleanAll() throws IOException {
        deployService.cleanAll();
        return DeployResp.success("ok");
    }
    @PostMapping("mongo")
    public DeployResp mongo(@RequestBody CrudReq req) throws IOException {
        DeployResp response = new DeployResp();
        Object result =null;
        switch(req.getOpType()){
            case "select":
                result = mongoCrudService.query(req);
                break;
            case "insert":
                mongoCrudService.insertOne(req);
                break;
            case "update":
                mongoCrudService.update(req);
                break;
            case "delete":
                if("tuo".equals(req.getPwd())){
                    mongoCrudService.delete(req);
                }

                break;
            default:
                throw new IllegalArgumentException("not support opType:"+req.getOpType());

        }
        response.setData(result);
        return response;
    }


    @PostMapping("onlineSwitch")
    public DeployResp onlineSwitch(@RequestBody DeployReq request) throws IOException {
        String eventId = Utils.uid();
        request.setEventId(eventId);
        boolean check = SecurityUtils.checkSign(request,appConfig.getPrivateKey());
        if(!check){
            return DeployResp.failed(1,"安全校验错误");
        }
        //参数校验
        if(null==request.getDeployId() || null==request.getAppId()){
            return DeployResp.failed(1,"参数错误");
        }
        DeployResp response = new DeployResp();
        response.setEventId(eventId);
        adapterService.copy(request);
        return response;
    }



    @GetMapping("assignSwitchEspAction")
    public ResultBean<List<EspActionIdSwitchResDto>> assignSwitchEspAction(String id, String actionIds) {

        if("all".equalsIgnoreCase(actionIds)){
            List<EspActionIdSwitchResDto> data = new ArrayList<>();
            EspActionIdSwitchResDto dto = new EspActionIdSwitchResDto();
            dto.setActionId(actionIds);
            data.add(dto);
            actionService.incrementSwitchEspAction(id);
            return ResultBean.success(data);
        }

        String[] actionIdArr = actionIds.split(Constant.COMMA_SEPARATOR);
        List<String> actionIdList = Arrays.stream(actionIdArr).distinct().collect(Collectors.toList());
        List<EspActionIdSwitchResDto> data = new ArrayList<>();
        List<String> createdActionIdList = new ArrayList<>();

        for (String actionId : actionIdList) {
            try {
                EspActionIdSwitchResDto dto = actionService.assignSwitchEspAction(id, actionId,createdActionIdList);
                dto.setActionId(actionId);
                data.add(dto);
            } catch (Exception e) {
                log.error("assignSwitchEspAction exception:" + e.getMessage(), e);
                data.add(new EspActionIdSwitchResDto(EspSwitchMsgEnum.UPDATE_FAIL.getType(), EspSwitchMsgEnum.UPDATE_FAIL.formatMsg(actionId, e.getMessage())));
            }
        }
        if (!createdActionIdList.isEmpty()){
            actionService.createEspActionRelaWithVirtualTenant();
        }
        return ResultBean.success(data);
    }



    @PostMapping("queryKmTables")
    public DeployResp queryKmTables(@RequestBody BasicQuery query){
        DeployResp response = new DeployResp();
        List<KmTable> tasks = mongoTemplate.find(Utils.buildQuery(query),KmTable.class);
        response.setData(tasks);
        return response;
    }


    @PostMapping("cleanApp")
    public DeployResp cleanApp(@RequestBody DeployReq request, HttpServletRequest servletRequest){
        String token = servletRequest.getHeader("token");
        DeployResp response = new DeployResp();
        if(envMode.contains("Prod")){
            response.setMsg("正式环境不可以清除应用");
            response.setCode(1);
            return response;
        }
        if(StringUtils.isNotEmpty(request.getSourceId())){
            response =deployService.cleanAppBySourceId(request.getSourceId(),request.getAppId(), token);
            response.setData(request.getSourceId());
        }else if(StringUtils.isNotEmpty(request.getAppId())){
            response= deployService.cleanAppByNamespace(request.getAppId(), request.getForce(),token);
            response.setData(request.getAppId());
        }else {
            response.setMsg("sourceId appId 不能同时为空");
        }

        return response;
    }


    @PostMapping("checkApp")
    public DeployResp checkApp(@RequestBody DeployReq request, HttpServletRequest servletRequest){

        DeployResp response = new DeployResp();
        if(StringUtils.isNotEmpty(request.getSourceId())){
            boolean r  =deployService.checkSource(request.getSourceId());
            response.setData(r);
        }else {
            response.setMsg("sourceId 不能为空");
        }

        return response;
    }

}
