package com.digiwin.athena.km_deployer_service.controller;

import com.digiwin.athena.deploy.DeployResp;
import com.digiwin.athena.km_deployer_service.povo.CommonParadigmDeployDto;
import com.digiwin.athena.km_deployer_service.service.ParadigmDeployService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * 范式发版
 */
@RestController
@RequestMapping("/paradigm/deploy")
@Slf4j
public class ParadigmDeployController {

    @Autowired
    private ParadigmDeployService paradigmDeployService;

    @PostMapping("deployApp")
    public DeployResp deployApp(@RequestBody CommonParadigmDeployDto request) throws IOException {
        DeployResp response = paradigmDeployService.publishApplication(request);
        return response;
    }
}
