package com.digiwin.athena.km_deployer_service.controller;

import com.digiwin.athena.km_deployer_service.povo.DeployRequest;
import com.digiwin.athena.km_deployer_service.povo.DeployResponse;
import com.digiwin.athena.km_deployer_service.domain.km.KmDeployEvent;
import com.digiwin.athena.km_deployer_service.domain.km.KmDeployLog;
import com.digiwin.athena.km_deployer_service.domain.km.KmEventParam;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.DeployTenantRequest;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.km.IPublishService;
import com.digiwin.athena.km_deployer_service.service.km.ITenantPublishService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/publish")
@Slf4j
public class PublishController {


    @Autowired
    MongoCrudService mongoCrudService;

    @Autowired
    IPublishService publishService;

    @Autowired
    ITenantPublishService tenantPublishService;

    @Autowired
    MongoTemplate mongoTemplate;

    @GetMapping("test01")
    public Object test01(){
        System.out.println("test01....");

        CrudReq req = new CrudReq();
        req.setDbName("datamap");
        req.setColName("api");
        req.setParams(new HashMap<>());
        req.getParams().put("key1",1);

        List list = mongoCrudService.query(req);

        return list;
    }

    @PostMapping("deployApp")
    public DeployResponse deployApp(@RequestBody DeployRequest request){
        DeployResponse response = new DeployResponse();
        //做一些检查
        if(null==request.getVersion() || null==request.getAppId() || null==request.getFileId()){
            response.setCode(-1);
            response.setMsg("参数错误");
            return response;
        }
        Query query = Query.query(Criteria.where("appId").is(request.getAppId()).and("status").is(1));
        if(Boolean.TRUE.equals(request.getForcePub())){
            mongoTemplate.remove(query, KmDeployEvent.class);
        }
        KmDeployEvent eventInDb = mongoTemplate.findOne(query,KmDeployEvent.class);
        if(null!=eventInDb){
            response.setCode(-1);
            response.setMsg("该应用正在发布中，请勿重复操作！");
            return response;
        }

        request.setDeployId(HelpService.uuid());
        request.setEventId(HelpService.uuid());
        publishService.publishApplication(request);
        response.setDeployId(request.getDeployId());
        response.setEventId(request.getEventId());
        return response;
    }

    @PostMapping("switchApp")
    public DeployResponse switchApp(@RequestBody DeployRequest request){
        DeployResponse response = new DeployResponse();
        request.setEventId(HelpService.uuid());

        Query query = Query.query(Criteria.where("appId").is(request.getAppId()).and("status").is(2));
        query.with(Sort.by(Sort.Direction.DESC,"updateTime"));
        KmDeployEvent event = mongoTemplate.findOne(query,KmDeployEvent.class);
        if(null==event){
            response.setCode(-1);
            response.setMsg("未找到上次发版成功的记录，请先发版！");
            return response;
        }
        publishService.switchApplication(request);

        response.setEventId(request.getEventId());
        return response;
    }

    @PostMapping("deployLogs")
    public DeployResponse deployLogs(@RequestBody DeployRequest request){
        DeployResponse response = new DeployResponse();

        Query query = Query.query(new Criteria().orOperator(Criteria.where("eventId").is(request.getEventId()),Criteria.where("switchEventId").is(request.getEventId())));
        KmDeployEvent event = mongoTemplate.findOne(query,KmDeployEvent.class);
        if(null!=event){
            response.setStatus(event.getStatus());
            if(null!=event.getStatus() && event.getStatus()>3){
                //开发平台要求 只需要 进行中 已完成 错误 3个状态
                response.setStatus(event.getStatus()-3);
            }
        }
        List<KmDeployLog> logs = publishService.deployLogs(request);
        response.setData(logs);
        return response;
    }

    @PostMapping("event")
    public DeployResponse event(@RequestBody KmEventParam param){
        DeployResponse deployResponse = new DeployResponse();
        try {
            publishService.handleEvent(param);
        } catch (Exception e) {
            log.error("事件发布异常：", e);
            deployResponse.setCode(-1);
            deployResponse.setMsg(e.getMessage());
        }
        return deployResponse;
    }



    @PostMapping("deployTenant")
    public DeployResponse deployTenant(@RequestBody DeployTenantRequest request){
        DeployResponse response = new DeployResponse();
        //做一些检查
        if(null==request.getTenantId() || null==request.getDataId()|| null==request.getFileId()){
            response.setCode(-1);
            response.setMsg("参数错误");
            return response;
        }

        response = tenantPublishService.publishTenant(request);
        return response;
    }

    @PostMapping("revokeDeployTenant")
    public DeployResponse revokeDeployTenant(@RequestBody DeployTenantRequest request){
        DeployResponse response = new DeployResponse();
        //做一些检查
        if(null==request.getTenantId() || null==request.getDataId()){
            response.setCode(-1);
            response.setMsg("参数错误");
            return response;
        }

        response = tenantPublishService.revokeTenant(request);
        return response;
    }
}
