package com.digiwin.athena.km_deployer_service.controller;

import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.povo.PageVo;
import com.digiwin.athena.km_deployer_service.povo.ServerMapInsertReq;
import com.digiwin.athena.km_deployer_service.povo.ServerMapReq;
import com.digiwin.athena.km_deployer_service.service.ServerMapService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/servermap")
@Slf4j
public class ServerMapController {

    private final ServerMapService serverMapService;

    public ServerMapController(ServerMapService serverMapService) {
        this.serverMapService = serverMapService;
    }

    @GetMapping("/analysis")
    public void analysis() {
        serverMapService.deleteAll();
        serverMapService.analysisServer();
    }

    @PostMapping("/query")
    public PageVo<EspServiceMapDto> query(ServerMapReq req) {
        return serverMapService.query(req);
    }

    @PostMapping("/delete")
    public void delete(ServerMapReq req) {
        serverMapService.delete(req);
    }

    @PostMapping("/update")
    public void update(ServerMapReq req) {
        serverMapService.update(req);
    }

    @PostMapping("/insert")
    public void insert(ServerMapInsertReq req) {
        serverMapService.insert(req.getDto());
    }
}
