package com.digiwin.athena.km_deployer_service.controller;

import com.digiwin.athena.km_deployer_service.povo.CopyDataDTO;
import com.digiwin.athena.km_deployer_service.service.CleanableCaches;
import com.digiwin.athena.km_deployer_service.service.ToolService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import lombok.extern.slf4j.Slf4j;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

@RestController
@RequestMapping("/test")
@Slf4j
public class TestController {


    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    ToolService toolService;

    @Autowired
    CleanableCaches cleanableCaches;


    @GetMapping("test01")
    public Object test01(){
        System.out.println("test01...."+Runtime.getRuntime().availableProcessors());
        return "list";
    }

    @GetMapping("cleanTables")
    public Object cleanTables(){
        System.out.println("cleanTables...."+Runtime.getRuntime().availableProcessors());
        cleanableCaches.cleanAll();
        return "list";
    }


    @PostMapping("copyCol")
    public Object copyCol(@RequestBody CopyDataDTO req){
        int c = copyData(req,new BsonDocument());
        return c;
    }


    @PostMapping("copyTenant")
    public Object copyTenant(@RequestBody CopyDataDTO req){

        Map<String,Integer> count = new HashMap<>();
        List<String> cols  = Arrays.asList("activity","task","project","emailView","flowGraph","pageUIElement","pageView",
                "process","dataDescription","dataFeature","dataState","eventSubscribe","eventTemplate","openWindowDecision");
        List<String> cols2  = Arrays.asList("ActivityAdaptation","PageViewAdaptation","PageUIElementAdaptation","erpSyncRecord",
                "pluginBinding","pluginRecord","mechanismDecision","mechanismDecisionTarget","taskSchedule");
        Bson bson = Filters.and(
                Filters.ne("tenantId", "SYSTEM"),
                Filters.ne("athena_publishType", "individualCase")
        );
        Bson bson2 = new BsonDocument();
        if(!CollectionUtils.isEmpty(req.getTenantIds())){
            bson = Filters.and(
                    Filters.in("tenantId",req.getTenantIds()),
                    Filters.ne("athena_publishType", "individualCase")
            );
            bson2 =  Filters.in("tenantId",req.getTenantIds());
        }
        for(String col:cols){
            System.out.println("copy "+col);
            CopyDataDTO dto = new CopyDataDTO();
            dto.setFromDb(req.getFromDb());
            dto.setToDb(req.getToDb());
            dto.setFromCol(col);
            dto.setToCol(col);
            int c = copyData(dto,bson);
            count.put(col,c);
        }
        for(String col:cols2){
            System.out.println("copy " + col);
            CopyDataDTO dto = new CopyDataDTO();
            dto.setFromDb(req.getFromDb());
            dto.setToDb(req.getToDb());
            dto.setFromCol(col);
            dto.setToCol(col);
            int c = copyData(dto,bson2);
            count.put(col,c);
        }
        return count;
    }


    private int copyData(CopyDataDTO req,Bson bson){
        int batchSize = 1000;
        AtomicInteger count = new AtomicInteger();
//        if(Boolean.TRUE.equals(req.getCleanTo())){
//            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getToDb()).getCollection(req.getToCol()).deleteMany(new BsonDocument());
//        }
        List<Document> list = new ArrayList<>();
        FindIterable<Document> docs = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).find(bson);
        docs.forEach((Consumer<? super Document>) doc->{
            list.add(doc);
            if(list.size()==batchSize){
                insert(list,req.getToDb(),req.getToCol());
                list.clear();
                count.addAndGet(batchSize);
            }
        });
        if(list.size()>0){
            insert(list,req.getToDb(),req.getToCol());
            count.addAndGet(list.size());
        }

        return count.get();
    }


    private void insert(List<Document> list ,String db,String col){
        try {
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(col).insertMany(list);
        }catch (Exception e){
            for(Document doc:list){
                try {
                    mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(col).insertOne(doc);
                }catch (Exception e2){

                }
            }
        }

    }


    @PostMapping("createIndex")
    public Object createIndex(@RequestBody CopyDataDTO req){
        Bson index1 = Indexes.ascending(req.getFields());
        IndexOptions options = new IndexOptions();
        options.unique(Boolean.TRUE.equals(req.getUnique()));
        String name = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).createIndex(index1,options);
        return name;
    }

    @PostMapping("createIndexAll")
    public Object createIndexAll(@RequestBody CopyDataDTO req){
        Bson tenantIdCode = Indexes.ascending("tenantId","code");
        List<String> colsUseCode  = Arrays.asList("activity","task","project","emailView","flowGraph","pageUIElement","pageView",
                "process","dataDescription","dataFeature","dataState","openWindowDecision","ActivityAdaptation","PageViewAdaptation","PageUIElementAdaptation");

        for(String col: colsUseCode){
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(col).createIndex(tenantIdCode);
        }
        return colsUseCode;
    }

    @PostMapping("dropIndex")
    public Object dropIndex(@RequestBody CopyDataDTO req){
        mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).dropIndex(req.getIndexName());
        return req.getIndexName();
    }

    @PostMapping("listIndex")
    public Object listIndex(@RequestBody CopyDataDTO req){
        ListIndexesIterable<Document> docs = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(req.getFromDb()).getCollection(req.getFromCol()).listIndexes();
        List result = new ArrayList<>();
        docs.forEach(new Consumer<Document>() {
            @Override
            public void accept(Document document) {
                result.add(document);
            }
        });
        return result;
    }

    @GetMapping("copyEntity")
    public Object copyEntity(){
        Map<String,Object> result =toolService.copyEntity();
        return result;
    }

    @GetMapping("processSubType")
    public Object processSubType(){
        toolService.updateSubType();
        return "ok";
    }

    @GetMapping("copyActivity")
    public Object copyActivity(@RequestParam(value = "pwd") String pwd){
        if (!"copyActivity@123".equals(pwd)) {
            return "pwd error";
        }
        Map<String,Object> result =toolService.copyActivity();
        return result;
    }

    @GetMapping("getActivity")
    public Object getActivity(){
        return toolService.getActivity();
    }
}
