package com.digiwin.athena.km_deployer_service.domain.asa.assistant;

import lombok.Builder;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author cai chao
 * @Date 2024/4/17 11:48
 */
@Data
@Builder
@Document(collection = "assistant")
public class Assistant {

    /**
     * 主键编号
     */
    @Id
    private String id;

    /**
     * 助理编号
     */
    private String assistantCode;

    /**
     * 分类
     */
    private String category;

    /**
     * 助理名称
     */
    private String name;

    /**
     * 助理头像
     */
    private String assistantAvatar;

    /**
     * 助理头像格式
     */
    private String avatarType;

    /**
     * 助理描述
     */
    private String description;

    /**
     * 助理账号
     */
    private String accid;

    /**
     * 助理评分
     */
    private String assistantScore;

    /**
     * 助理类型（0:仅限C娜 1:仅限B娜 2:通用助理（C娜及B娜都可用））
     */
    private Integer assistantType;

    /**
     * 助理子类型（3事务类 #2知识类 #1数据类）
     */
    private Integer assistantSubType;

    /**
     * 关键词
     */
    private List<String> searchKeywords;

    /**
     * 版本【1.0:beta，2.0:正式版本】
     */
    private String version;

    /**
     * 助理开启状态（0:关闭，1:开启）
     */
    private Integer status;

    /**
     * 租户
     */
    private String tenantId;

    /**
     * 技能类型
     */
    private String skillType;

    /**
     * 多语言
     */
    private Map<String, Map<String, Object>> lang;

    /**
     * 是否是定制化
     * true:定制化，false:非定制化
     */
    private Boolean sourceCustom;

    private String assistantAsaCode;

    /**
     * 客户端类型 ["APP", "WEB"],
     */
    private List<String> clientType;

    /**
     * 助理排序
     */
    private Integer sort;


    private String assistantAvatarB;

    private String avatarTypeB;

    private String knowledgeType;

    private AiProject aiProject;
}
