package com.digiwin.athena.km_deployer_service.domain.asa.deploy;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Optional;

/**
 * @author liyuetao
 * @title: DeployProcess
 * @projectName athena_deployer
 * @description: TODO
 * @date 2022/7/1313:56
 */
@Data
@Accessors(chain = true)
public class DeployProcess {
    private Integer total;

    private Integer left;

    private Integer deployedNum;

    private String type;

    public void deployedNumIncrease() {
        Integer deployedNum = Optional.ofNullable(getDeployedNum()).orElse(0);
        deployedNum++;
        if (deployedNum < getTotal()) {
            setDeployedNum(deployedNum);
        }
    }

    public void leftDecrease() {
        Integer left = Optional.ofNullable(getLeft()).orElse(getTotal());
        left--;
        setLeft(left);
    }
}
