package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.digiwin.athena.domain.core.LifecycleEvent;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.MatchCondition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.ScheduleRule;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.TagDefinition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.UserDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 * type活动类型: http esp action执行引擎 serviceComposer服务编排  script createData
 * composite invokeProject invokeTask invokeFlow taskEvent推送任务事件
 * manual approve wait一直等待 stopProject notice
 **/
@Document(collection = "activity")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActivityModel extends BaseModel {
    private String type;
    private Boolean milestone;
    private UserDefinition executor;
    private List<LifecycleEvent> events;
    private String application;
    private String code;
    private String name;
    private Integer score = AsaConstant.Val.SCORE;
    private List<MatchCondition> matches;
    private List<TagDefinition> tags;
    private Map<String, Object> config;
    private ScheduleRule scheduleRule;
}
