package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description
 * @Author cai chao
 * @Date 2024/8/2 13:13
 */
@Data
@Document(collection = "asa_model_corpus")
public class AssistantModelCorpus {

    /**
     * 主键编号
     */
    @Id
    private String objectId;


    /**
     * 语料代号
     */
    private String corpusCode;

    /**
     * 项目代号==助理代号
     */
    private String projectCode;

    /**
     * 模型code
     */
    private String modelCode;

    /**
     * 1-样例语料 2-测试语料 3-训练语料 4-none样例语料 5-NG语料 6-优化语料
     */
    private Integer corpusType;

    /**
     * 原始类型  4-none样例语料 6-优化语料
     */
    private Integer originalType;

    /**
     * 场景名称
     */
    private String intent;

    /**
     * 语料，初始语料对应场景话术
     */
    private String utterances;

    /**
     * 原始语料，train_opt_data有效
     */
    private String originalText;

    /**
     * 生成方式 auto|manual
     */
    private String generateMode;

    /**
     * 语料标记 correct|incorrect|ambiguous|multi-intent|generate|no generate
     */
    private String label;

    /**
     * 归属模型 ALL|LLM|NLU|model_1|model_2
     */
    private String modelType;

    /**
     * 基础版本
     */
    private String baseVersion;

    /**
     * 训练版本
     */
    private String trainVersion;

    /**
     * 原始版本，train_data有效
     */
    private String originalVersion;





    public static List<Map> constructRhProjectNotLabel(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            Map map = new HashMap();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            map.put("label", assistantModelCorpus.getLabel());
            return map;
        }).collect(Collectors.toList());
    }

    public static List<Map> constructRhProject(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            Map map = new HashMap();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            map.put("label", assistantModelCorpus.getLabel());
            return map;
        }).collect(Collectors.toList());
    }

    public static List<Map> constructTrainOptimal(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            Map map = new HashMap();
            map.put("intent", assistantModelCorpus.getIntent());
            map.put("utterances", assistantModelCorpus.getUtterances());
            map.put("original_text", assistantModelCorpus.getOriginalText());
            map.put("label", assistantModelCorpus.getLabel());
            return map;
        }).collect(Collectors.toList());
    }

    public static List<JSONObject> constructTest(List<AssistantModelCorpus> assistantModelCorpuses) {
        return CollUtil.emptyIfNull(assistantModelCorpuses).stream().map(assistantModelCorpus -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("intent", assistantModelCorpus.getIntent());
            jsonObject.put("text", assistantModelCorpus.getUtterances());
            return jsonObject;
        }).collect(Collectors.toList());
    }

    public static String generateKey(String intent, String utterance) {
        return intent + "_" + utterance;
    }
}
