package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Description 模型项目表
 * @Author cai chao
 * @Date 2024/8/2 10:25
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Document(collection = "asa_assistant_project")
public class AssistantProject {

    /**
     * 主键编号
     */
    @Id
    private String objectId;

    /**
     * 项目编号[项目代号==助理代号]
     */
    private String projectCode;

    /**
     * 助理编号
     */
    private String assistantCode;

    /**
     * 语言[模型语言 zh-hans|zh-hant|en，默认zh_hans]
     */
    private String language = "zh_hans";

    /**
     * 昵称
     */
    private List<String> nickname;

    /**
     * 项目类型，默认entry
     */
    private String type = "entry";

    /**
     * beta版使用版本
     */
    private Map<String, String> betaModel;

    /**
     * 正式版使用版本
     */
    private Map<String, String> commercialModel;

    /**
     * 获取当前使用模型code
     *
     * @return
     */
    public Set getUseModelCode() {
        Set useModelCode = new HashSet();
        this.getBetaModel().forEach((k, v) -> useModelCode.add(v));
        this.getCommercialModel().forEach((k, v) -> useModelCode.add(v));
        return useModelCode;
    }


}
